/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector;

import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ResultSetController
extends AbstractInspectorController {
    private static final Log log = LogFactory.getLog(ResultSetController.class);
    @Resource(name="resultSetClientFactory")
    private ResultSetClientFactory resultSetClientFactory;
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;

    @RequestMapping(value={"/inspector/rs.do"})
    public void resultset(ModelMap model, @RequestParam(value="query", required=false) String query, @RequestParam(value="epr", required=false) String epr) {
        if (query != null || epr != null) {
            log.info((Object)"building resultset from query or EPR");
            try {
                if (query != null) {
                    epr = ((ISLookUpService)this.lookupLocator.getService()).searchProfile(query).toString();
                }
                IterableResultSetClient client = this.resultSetClientFactory.getClient(epr);
                model.addAttribute("message", (Object)"resultset elements listed below:");
                model.addAttribute("iter", (Object)client.iterator());
            }
            catch (Exception e) {
                model.addAttribute("message", (Object)("failed: " + e.getMessage()));
                model.addAttribute("iter", (Object)"");
            }
        }
        model.addAttribute("query", (Object)query);
        model.addAttribute("epr", (Object)epr);
    }
}

