/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector;

import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.is.sn.NotificationInvocationLogger;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscription;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscriptionRegistry;
import eu.dnetlib.miscutils.coupling.StaticCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SubscriptionController
extends AbstractInspectorController {
    private static final Log log = LogFactory.getLog(SubscriptionController.class);
    @Resource(name="issResourceStateNotificationRegistries")
    private transient List<ResourceStateSubscriptionRegistry> registries;
    @Resource(name="issnInhibitionCondition")
    private transient StaticCondition inhibitionCondition;
    @Resource
    private transient NotificationInvocationLogger invocationLogger;

    @RequestMapping(value={"/inspector/sn.do"})
    String listSubscriptions(Model model) throws XPathExpressionException {
        log.debug((Object)("registries: " + this.registries));
        ArrayList subscriptions = new ArrayList();
        for (ResourceStateSubscriptionRegistry registry : this.registries) {
            for (ResourceStateSubscription sub : registry.getSubscriptionDao().listSubscriptions()) {
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("prefix", sub.getPrefix());
                attrs.put("type", sub.getType());
                attrs.put("resourceId", sub.getResourceId());
                attrs.put("xpath", sub.getXpath());
                attrs.put("id", sub.getSubscriptionId());
                DOMResult result = new DOMResult();
                sub.getSubscriber().writeTo((Result)result);
                attrs.put("address", XPathFactory.newInstance().newXPath().evaluate("//*[local-name() = 'Address']", result.getNode()));
                subscriptions.add(attrs);
            }
        }
        model.addAttribute("subscriptions", subscriptions);
        model.addAttribute("enabled", (Object)(!this.inhibitionCondition.isTrue() ? 1 : 0));
        return "inspector/subscriptions";
    }

    @RequestMapping(value={"/inspector/snByAddress.do"})
    String listSubscriptionsByAddress(Model model, @RequestParam(value="address", required=false) String address) throws XPathExpressionException {
        log.debug((Object)("registries: " + this.registries));
        ArrayList subscriptions = new ArrayList();
        log.debug((Object)("Address is " + address));
        model.addAttribute("address", (Object)address);
        for (ResourceStateSubscriptionRegistry registry : this.registries) {
            for (ResourceStateSubscription sub : registry.getSubscriptionDao().listSubscriptions()) {
                DOMResult result = new DOMResult();
                sub.getSubscriber().writeTo((Result)result);
                String addr = XPathFactory.newInstance().newXPath().evaluate("//*[local-name() = 'Address']", result.getNode());
                if (address != null && (addr == null || !addr.startsWith(address))) continue;
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("prefix", sub.getPrefix());
                attrs.put("type", sub.getType());
                attrs.put("resourceId", sub.getResourceId());
                attrs.put("xpath", sub.getXpath());
                attrs.put("id", sub.getSubscriptionId());
                attrs.put("address", addr);
                subscriptions.add(attrs);
            }
        }
        model.addAttribute("subscriptions", subscriptions);
        model.addAttribute("enabled", (Object)(!this.inhibitionCondition.isTrue() ? 1 : 0));
        return "inspector/subscriptionsByAddress";
    }

    @RequestMapping(value={"/inspector/toggleNotifications.do"})
    String deleteSubscription() {
        this.inhibitionCondition.setCondition(!this.inhibitionCondition.isTrue());
        return "redirect:sn.do";
    }

    @RequestMapping(value={"/inspector/deleteSubscription.do"})
    String deleteSubscription(@RequestParam(value="id") String subscriptionId) {
        for (ResourceStateSubscriptionRegistry registry : this.registries) {
            if (registry.getSubscriptionDao().removeSubscription(subscriptionId)) break;
        }
        return "redirect:sn.do";
    }

    @RequestMapping(value={"/inspector/deleteSubscriptionsByAddress.do"})
    String deleteSubscriptionsByAddress(Model model, @RequestParam(value="address") String address) throws XPathExpressionException {
        ArrayList<String> deleted = new ArrayList<String>();
        if (address != null && address.length() > "http://".length()) {
            for (ResourceStateSubscriptionRegistry registry : this.registries) {
                for (ResourceStateSubscription sub : registry.getSubscriptionDao().listSubscriptions()) {
                    DOMResult result = new DOMResult();
                    sub.getSubscriber().writeTo((Result)result);
                    String addr = XPathFactory.newInstance().newXPath().evaluate("//*[local-name() = 'Address']", result.getNode());
                    if (addr == null || !addr.startsWith(address)) continue;
                    String id = sub.getSubscriptionId();
                    registry.getSubscriptionDao().removeSubscription(id);
                    deleted.add(id + " (" + addr + ")");
                }
            }
        }
        model.addAttribute("deleted", deleted);
        return "inspector/deleteSubscriptionsByAddress";
    }

    @RequestMapping(value={"/inspector/notificationLog.do"})
    void notificationLog(Model model) {
        model.addAttribute("log", (Object)this.invocationLogger.getEntries());
    }
}

