package eu.dnetlib.enabling.inspector;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.xmldb.api.base.XMLDBException;

import eu.dnetlib.xml.database.XMLDBResultSet;
import eu.dnetlib.xml.database.XMLDatabase;

/**
 * This controller offers a simple way to run arbitrary queries on the xmldb.
 *
 * @author marko
 *
 */
@Controller
public class QueryController extends AbstractInspectorController {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(QueryController.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * xmldb.
	 */
	@Resource(name = "existDatabase")
	private transient XMLDatabase xmlDatabase;
	
	/**
	 * utility to parse resource ids and allows to navigate them.
	 */
	@Resource(name = "resourcelinkTool")
	private ResourceLinkTool linkTool;	

	/**
	 * run a query.
	 *
	 * @param model
	 *            mvc model
	 * @param query
	 *            query (optional)
	 * @throws
	 */
	@RequestMapping(value = "/inspector/query.do")
	void query(final Model model, @RequestParam(value = "query", required = false) final String query) {
		if (query != null) {
			log.info("running query: " + query);

			try {
				final XMLDBResultSet res = xmlDatabase.xquery(query);
				model.addAttribute("size", res.getSize());
				
				final List<String> results = new ArrayList<String>();
				for (int i = 0; i < res.getSize(); i++)
					results.add(linkTool.linkfyToHtml(StringEscapeUtils.escapeHtml(res.get(i))));

				model.addAttribute("results", results);
			} catch (XMLDBException e) {
				model.addAttribute("message", "failed: " + e.getMessage());
			}
		}

		model.addAttribute("query", query);

	}

}
