package eu.dnetlib.enabling.inspector;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;

/**
 * This controller allows to inspect the elements of a resultset
 * built by running an arbitrary xquery.
 * 
 * @author claudio
 *
 */
@Controller
public class ResultSetController extends AbstractInspectorController {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(ResultSetController.class);
	
	/**
	 * resultset client.
	 */
	@Resource(name = "resultSetClientFactory")
	private ResultSetClientFactory resultSetClientFactory;
	
	/**
	 * lookup locator.
	 */
	@Resource(name = "lookupLocator")
	private ServiceLocator<ISLookUpService> lookupLocator;
	
	/**
	 * build a resultset and show its content.
	 * 
	 * @param model
	 * 				mvc model
	 * @param query
	 * 				query (optional)
	 * @param epr
	 * 				epr (optional)
	 * @throws Exception
	 */
	@RequestMapping("/inspector/rs.do")
	public void resultset(
			final ModelMap model,
			@RequestParam(value = "query", required = false) final String query, 
			@RequestParam(value = "epr",   required = false) String epr) {

		if (query != null || epr != null) {
			
			log.info("building resultset from query or EPR");
			try {
				if (query != null)
					epr = lookupLocator.getService().searchProfile(query).toString();
				IterableResultSetClient client = resultSetClientFactory.getClient(epr);
				model.addAttribute("message", "resultset elements listed below:");
				model.addAttribute("iter", client.iterator());
			} catch (Exception e) {
				model.addAttribute("message", "failed: " + e.getMessage());
				model.addAttribute("iter", "");
			}
		}
		model.addAttribute("query", query);
		model.addAttribute("epr", epr);
	}	

}
