/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hadoop;

import com.mongodb.hadoop.MongoInputFormat;
import com.mongodb.hadoop.util.MongoConfigUtil;
import eu.dnetlib.enabling.manager.msro.hadoop.HopeEDMMapper;
import eu.dnetlib.enabling.manager.msro.hadoop.HopeEDMReducer;
import eu.dnetlib.enabling.manager.msro.hadoop.MDStoreOutputFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;

public class HopeEDMTransformer
extends Configured
implements Tool {
    private static final Log log = LogFactory.getLog(HopeEDMTransformer.class);

    public int run(String[] args) throws Exception {
        Configuration conf = new Configuration();
        String mdstoreName = args[0];
        String mongoHostName = args[5];
        MongoConfigUtil.setInputURI((Configuration)conf, (String)("mongodb://" + mongoHostName + "/" + mdstoreName + "." + args[1]));
        MongoConfigUtil.setOutputURI((Configuration)conf, (String)("mongodb://" + mongoHostName + "/" + mdstoreName + "." + args[2]));
        conf.setStrings("repoId", new String[]{args[3]});
        conf.setStrings("xsltCode", new String[]{args[4]});
        log.debug((Object)("Conf: " + conf));
        Job job = new Job(conf, "edm transformer job");
        job.setMapperClass(HopeEDMMapper.class);
        job.setReducerClass(HopeEDMReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormatClass(MongoInputFormat.class);
        job.setOutputFormatClass(MDStoreOutputFormat.class);
        long start = new Date().getTime();
        job.waitForCompletion(true);
        long end = new Date().getTime();
        log.info((Object)("MAP/REDUCE JOB completed in " + (end - start) / 1000L + " seconds"));
        return 0;
    }
}

