/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hadoop;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class MDStoreRecordWriter
extends RecordWriter<Text, Text> {
    private final String[] updateKeys;
    private final boolean multiUpdate;
    final DBCollection _collection;
    final TaskAttemptContext _context;

    public MDStoreRecordWriter(DBCollection c, TaskAttemptContext ctx, String[] updateKeys) {
        this(c, ctx, updateKeys, false);
    }

    public MDStoreRecordWriter(DBCollection c, TaskAttemptContext ctx, String[] updateKeys, boolean multi) {
        this._collection = c;
        this._context = ctx;
        this.updateKeys = updateKeys;
        this.multiUpdate = false;
    }

    public void write(Text key, Text value) throws IOException {
        BasicDBObject o = new BasicDBObject();
        o.put("id", (Object)key.toString());
        o.put("originalId", (Object)key.toString());
        o.put("body", (Object)value.toString());
        o.put("timestamp", (Object)DateUtils.now());
        try {
            if (this.updateKeys == null) {
                this._collection.save((DBObject)o);
            } else {
                BasicDBObject query = new BasicDBObject(this.updateKeys.length);
                for (String updateKey : this.updateKeys) {
                    query.put(updateKey, o.get(updateKey));
                    o.removeField(updateKey);
                }
                if (o.get("_id") == null) {
                    o.removeField("_id");
                }
                BasicDBObject set = new BasicDBObject().append("$set", (Object)o);
                this._collection.update((DBObject)query, (DBObject)set, true, this.multiUpdate);
            }
        }
        catch (MongoException e) {
            throw new IOException("can't write to mongo", e);
        }
    }

    public MDStoreRecordWriter(DBCollection coll, TaskAttemptContext ctx) {
        this(coll, ctx, null);
    }

    public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
        this._collection.getDB().getLastError();
    }

    public void ensureIndex(DBObject index, DBObject options) {
        this._collection.ensureIndex(index, options);
    }

    public TaskAttemptContext getContext() {
        return this._context;
    }
}

