/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.information.DataSinkSourceException;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Required;

public class IsHopeFormat
extends AbstractJobNode {
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String formatAttributeName;
    private DataSourceResolver dataSourceResolver;

    public void execute(Engine engine, NodeToken token) {
        Env env = token.getFullEnv();
        String repoFormat = env.getAttribute(this.formatAttributeName);
        try {
            if (repoFormat.equalsIgnoreCase("hope")) {
                this.prepareEnvForDirectHOPEIngestion(env);
                engine.complete(token, "YES");
            } else {
                engine.complete(token, "NO");
            }
        }
        catch (ISLookUpException e) {
            super.failed(engine, token, (Throwable)e);
        }
        catch (DataSinkSourceException e) {
            super.failed(engine, token, (Throwable)e);
        }
    }

    private void prepareEnvForDirectHOPEIngestion(Env env) throws ISLookUpException, DataSinkSourceException {
        String repoId = env.getAttribute("repositoryId");
        String dataSourceQuery = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='HarvestingDSResourceType']//CONFIGURATION[./REPOSITORY_SERVICE_IDENTIFIER='" + repoId + "']/DATA_SINK/text()";
        String dataSource = (String)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(dataSourceQuery).get(0);
        W3CEndpointReference hopeEpr = this.dataSourceResolver.resolve(dataSource).retrieve();
        env.setTransientAttribute("hopeEpr", (Object)hopeEpr);
        String dataSinkQuery = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='TransformationDSResourceType']//CONFIGURATION[./REPOSITORY_SERVICE_IDENTIFIER='" + repoId + "' and SINK_METADATA_FORMAT/@name='hope' and SINK_METADATA_FORMAT/@interpretation='final' ]/DATA_SINK/text()";
        String dataSink = (String)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(dataSinkQuery).get(0);
        env.setAttribute("dataSink", dataSink);
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public String getFormatAttributeName() {
        return this.formatAttributeName;
    }

    public void setFormatAttributeName(String formatAttributeName) {
        this.formatAttributeName = formatAttributeName;
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    @Required
    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }
}

