/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope.thumbnails;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.manager.msro.hope.thumbnails.ThumbnailInfo;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.workflow.AbstractJobNode;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IM4JavaException;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;

public class DownloaderConverterJobNode
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(DownloaderConverterJobNode.class);
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    private final Gson gson = new Gson();
    private int width;
    private int height;
    private String thumbnailDir;
    private int nThreads = 10;
    private int nTasks = 100;

    public void execute(Engine engine, NodeToken token) {
        ExecutorService executor = Executors.newFixedThreadPool(this.nThreads);
        W3CEndpointReference downloadListEpr = (W3CEndpointReference)token.getEnv().getTransientAttribute("downloadListEpr");
        if (downloadListEpr == null) {
            this.failed(engine, token, new NullPointerException("downloadListEpr is null"));
            log.debug((Object)"downloadListEpr is null");
        } else {
            log.debug((Object)"Got epr downloadListEpr");
            IterableResultSetClient client = this.resultSetClientFactory.getClient(downloadListEpr);
            log.debug((Object)"Got client");
            File tmpDir = Files.createTempDir();
            log.debug((Object)("Created tmp dir at: " + tmpDir.getAbsolutePath()));
            IMOperation op = this.createConversionOperation();
            ArrayList tasks = Lists.newArrayList();
            Iterator itemsIterator = client.iterator();
            log.debug((Object)"iterating on client");
            int total = 0;
            Iterable results = Lists.newArrayList();
            while (itemsIterator.hasNext()) {
                int i = 0;
                while (i < this.nTasks && itemsIterator.hasNext()) {
                    String item = (String)itemsIterator.next();
                    ++total;
                    ThumbnailInfo thumb = (ThumbnailInfo)this.gson.fromJson(item, ThumbnailInfo.class);
                    String[] targetSplit = thumb.getThumbnailURL().split("/");
                    String destFileName = targetSplit[targetSplit.length - 1];
                    File target = new File(this.thumbnailDir + "/" + destFileName);
                    if (!target.exists()) {
                        DownloadAndConverter task = new DownloadAndConverter();
                        task.setInputURL(thumb.getInputURL());
                        task.setTargetFilePath(this.thumbnailDir + "/" + destFileName);
                        task.setTmpDir(tmpDir);
                        task.setConversionOp(op);
                        tasks.add(task);
                        ++i;
                        continue;
                    }
                    log.debug((Object)("Thumbnail already generated for " + thumb.getInputURL() + " in " + thumb.getThumbnailURL()));
                }
                try {
                    log.debug((Object)"Invoking tasks...");
                    results = Iterables.concat((Iterable)results, executor.invokeAll(tasks));
                }
                catch (InterruptedException e) {
                    log.debug((Object)("Some tasks might not be successfully completed, cause: " + e.getMessage()));
                }
                catch (Exception e) {
                    log.debug((Object)("Unexpectd exception: " + e.getMessage()));
                }
            }
            log.debug((Object)"Waiting for tasks completion");
            for (Future res : results) {
                try {
                    res.get();
                }
                catch (InterruptedException e) {
                    log.debug((Object)("Some tasks might not be successfully completed, cause: " + e.getMessage()));
                }
                catch (ExecutionException e) {
                    log.debug((Object)("Some tasks might not be successfully completed, cause: " + e.getMessage()));
                }
            }
            log.debug((Object)"executor shutdown ...");
            log.debug((Object)("Number of thumbnail processed: " + total));
            executor.shutdown();
            super.execute(engine, token);
        }
    }

    private IMOperation createConversionOperation() {
        IMOperation op = new IMOperation();
        op.addImage();
        op.define("jpeg:size=" + this.width * 2 + "x" + this.height * 2);
        op.thumbnail(Integer.valueOf(this.width), Integer.valueOf(this.height));
        op.unsharp(Double.valueOf(0.0), Double.valueOf(0.5));
        op.background("transparent");
        op.gravity("center");
        op.extent(Integer.valueOf(this.width), Integer.valueOf(this.height));
        op.colors(Integer.valueOf(256));
        op.addImage();
        return op;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public String getThumbnailDir() {
        return this.thumbnailDir;
    }

    public void setThumbnailDir(String thumbnailDir) {
        this.thumbnailDir = thumbnailDir;
    }

    public int getnThreads() {
        return this.nThreads;
    }

    public void setnThreads(int nThreads) {
        this.nThreads = nThreads;
    }

    public int getnTasks() {
        return this.nTasks;
    }

    public void setnTasks(int nTasks) {
        this.nTasks = nTasks;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    class DownloadAndConverter
    implements Callable<Boolean> {
        private String targetFilePath;
        private String inputURL;
        private File tmpDir;
        private IMOperation conversionOp;

        DownloadAndConverter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            File tmp = null;
            try {
                tmp = File.createTempFile("" + DateUtils.now(), "thumb", this.tmpDir);
                tmp.deleteOnExit();
                FileUtils.copyURLToFile((URL)new URL(this.inputURL), (File)tmp);
                ConvertCmd cmd = new ConvertCmd();
                File target = new File(this.targetFilePath);
                target.createNewFile();
                cmd.run((Operation)this.conversionOp, new Object[]{tmp.getAbsolutePath() + "[0]", this.targetFilePath});
                Boolean bl = true;
                return bl;
            }
            catch (MalformedURLException e) {
                log.debug((Object)("Cannot download file from: " + this.inputURL + ", cause: " + e.getMessage()));
                Boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                log.debug((Object)("Cannot copy file from: " + this.inputURL + ", cause: " + e.getMessage()));
                Boolean bl = false;
                return bl;
            }
            catch (InterruptedException e) {
                log.debug((Object)("Cannot convert into thumbnail file from: " + this.inputURL + ", cause: " + e.getMessage()));
                Boolean bl = false;
                return bl;
            }
            catch (IM4JavaException e) {
                log.debug((Object)("Cannot convert into thumbnail file from: " + this.inputURL + ", cause: " + e.getMessage()));
                Boolean bl = false;
                return bl;
            }
            finally {
                if (tmp != null) {
                    tmp.delete();
                }
            }
        }

        public String getTargetFilePath() {
            return this.targetFilePath;
        }

        public void setTargetFilePath(String targetFilePath) {
            this.targetFilePath = targetFilePath;
        }

        public String getInputURL() {
            return this.inputURL;
        }

        public void setInputURL(String inputURL) {
            this.inputURL = inputURL;
        }

        public File getTmpDir() {
            return this.tmpDir;
        }

        public void setTmpDir(File tmpDir) {
            this.tmpDir = tmpDir;
        }

        public IMOperation getConversionOp() {
            return this.conversionOp;
        }

        public void setConversionOp(IMOperation conversionOp) {
            this.conversionOp = conversionOp;
        }
    }
}

