package eu.dnetlib.enabling.manager.msro.hadoop;

import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;

import com.mongodb.hadoop.MongoInputFormat;
import com.mongodb.hadoop.util.MongoConfigUtil;

public class HopeTagTransformer extends Configured implements Tool {
	private static final Log log = LogFactory.getLog(HopeTagTransformer.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	public int run(String[] args) throws Exception {
		final Configuration conf = new Configuration();
		String mdstoreName = args[0];
		String mongoHostName = args[3];
		MongoConfigUtil.setInputURI(conf, "mongodb://" + mongoHostName + "/" + mdstoreName + "." + args[1]);
		MongoConfigUtil.setOutputURI(conf, "mongodb://" + mongoHostName + "/" + mdstoreName + "." + args[2]);

		final Job job = new Job(conf, "tag transformer job");

		job.setMapperClass(HopeTagMapper.class);
		job.setReducerClass(HopeTagReducer.class);

		job.setOutputKeyClass(Text.class);
		job.setOutputValueClass(Text.class);

		job.setInputFormatClass(MongoInputFormat.class);
		job.setOutputFormatClass(MDStoreOutputFormat.class);

		long start = (new Date()).getTime();
		job.waitForCompletion(true);
		long end = (new Date()).getTime();

		log.info("MAP/REDUCE JOB completed in " + ((end - start) / 1000) + " seconds");

		return 0;
	}

}
