package eu.dnetlib.enabling.manager.msro.hadoop;

import java.io.IOException;

import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;

import eu.dnetlib.miscutils.datetime.DateUtils;

public class MDStoreRecordWriter extends RecordWriter<Text, Text> {

	private final String[] updateKeys;
	private final boolean multiUpdate;

	final DBCollection _collection;
	final TaskAttemptContext _context;

	public MDStoreRecordWriter(DBCollection c, TaskAttemptContext ctx, String[] updateKeys) {
		this(c, ctx, updateKeys, false);
	}

	public MDStoreRecordWriter(DBCollection c, TaskAttemptContext ctx, String[] updateKeys, boolean multi) {
		_collection = c;
		_context = ctx;
		this.updateKeys = updateKeys;
		this.multiUpdate = false;
	}

	@Override
	public void write(Text key, Text value) throws IOException {
		final DBObject o = new BasicDBObject();
		o.put("id", key.toString());
		o.put("originalId", key.toString());

		o.put("body", value.toString());
		o.put("timestamp", DateUtils.now());

		try {
			if (updateKeys == null) {
				_collection.save(o);
			} else {
				// Form the query fields
				DBObject query = new BasicDBObject(updateKeys.length);
				for (String updateKey : updateKeys) {
					query.put(updateKey, o.get(updateKey));
					o.removeField(updateKey);
				}
				// If _id is null remove it, we don't want to override with null _id
				if (o.get("_id") == null) {
					o.removeField("_id");
				}
				DBObject set = new BasicDBObject().append("$set", o);
				_collection.update(query, set, true, multiUpdate);
			}
		} catch (final MongoException e) {
			throw new IOException("can't write to mongo", e);
		}
	}

	public MDStoreRecordWriter(DBCollection coll, TaskAttemptContext ctx) {
		this(coll, ctx, null);
	}

	@Override
	public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
		_collection.getDB().getLastError();

	}

	public void ensureIndex(DBObject index, DBObject options) {
		_collection.ensureIndex(index, options);
	}

	public TaskAttemptContext getContext() {
		return _context;
	}
}
