package eu.dnetlib.enabling.manager.msro.hope;

import javax.annotation.Resource;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler;

/**
 * NotificationHandler launched before the cleaning workflow starts.
 * 
 * @author alessia
 * 
 */
public class CleanHopeNotificationHandler extends AbstractWorkflowLauncherNotificationHandler {
	/**
	 * Used to create data source descriptors from MDStore id.
	 */
	@Resource
	private MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator;

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler#prepareProcess(com.googlecode.sarasvati.GraphProcess,
	 *      com.googlecode.sarasvati.env.Env, java.lang.String, java.lang.String)
	 */
	@Override
	protected void prepareProcess(final GraphProcess process, final Env env, final String rsId, final String profile) {
		env.setAttribute("dataSource", this.sourceDescriptionGenerator.generateDataSourceDescriptor(rsId));
	}
}
