package eu.dnetlib.enabling.manager.msro.hope;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;

/**
 * Finds two MDStores to be merged. TODO: this class is copied from the efg workflow module. If it is not changed, then
 * it woths to be put in a common package.
 * 
 * @author alessia
 * 
 */
public class FindMDStoresToMergeJob extends AbstractJobNode {
	/**
	 * lookup locator.
	 */
	private ServiceLocator<ISLookUpService> lookupLocator;

	private static final Log log = LogFactory.getLog(FindMDStoresToMergeJob.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	public void execute(final Engine engine, final NodeToken token) {
		try {
			final String inputID = token.getFullEnv().getAttribute("dataSource");

			final String xquery = "for $x in collection('/db/DRIVER/TransformationDSResources/TransformationDSResourceType') " + "where "
					+ "$x//SOURCE_METADATA_FORMAT/@interpretation='edited' and " + "$x//DATA_SOURCE='" + inputID + "' "
					+ "return concat($x//RESOURCE_IDENTIFIER/@value,'|-!-|',$x//DATA_SINK/text())";

			log.debug("XQUERY: " + xquery);

			final String s = this.lookupLocator.getService().getResourceProfileByQuery(xquery);

			final String[] arr = s.split("\\|-!-\\|");

			token.getEnv().setAttribute("dataDsId", arr[0]);
			token.getEnv().setAttribute("dataSink", arr[1]);
		} catch (final Exception e) {
			this.failed(engine, token, e);
		}
		super.execute(engine, token);
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return this.lookupLocator;
	}

	@Required
	public void setLookupLocator(final ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}
}
