package eu.dnetlib.enabling.manager.msro.hope;

import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.workflow.AbstractJobNode;

/**
 * Class copied from efg workflow. If it has to be commonly used maybe it worths to be moved in msro workflow.
 * @author alessia
 *
 */
public class UpdateLastUpdateJob extends AbstractJobNode {
	/**
	 * The IS-Registry locator.
	 */
	private ServiceLocator<ISRegistryService> registryLocator;
	
	private String lastUpdateField = "LAST_UPDATE_DATE";
	
	@Override
	public void execute(final Engine engine, final NodeToken token) {
		try {
			String profId = token.getFullEnv().getAttribute("dataDsId");
			final String xpath = "//" + lastUpdateField;
			final String xmldate = 
				"<" + lastUpdateField + ">" + 
				DateUtils.now_ISO8601() +
				"</" + lastUpdateField + ">";
			
			registryLocator.getService().updateProfileNode(profId, xpath, xmldate);
		
		} catch (Exception e) {
			failed(engine, token, e);
		}
		super.execute(engine, token);
	}


	public ServiceLocator<ISRegistryService> getRegistryLocator() {
		return registryLocator;
	}

	@Required
	public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
		this.registryLocator = registryLocator;
	}


	public void setLastUpdateField(String lastUpdateField) {
		this.lastUpdateField = lastUpdateField;
	}


	public String getLastUpdateField() {
		return lastUpdateField;
	}
}
