package eu.dnetlib.enabling.manager.msro.hope;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;

/**
 * Class copied from efg workflow. If it has to be commonly used maybe it worths to be moved in msro workflow.
 * 
 * @author alessia
 * 
 */
public class UpdateTDSStatusJob extends AbstractJobNode {
	private static final Log log = LogFactory.getLog(UpdateTDSStatusJob.class); // NOPMD by marko on 11/24/08 5:02 PM

	private ServiceLocator<ISRegistryService> registryLocator;
	private ServiceLocator<ISLookUpService> lookupLocator;

	private String status = "TAGGED";
	private String inputMdFormat = "hope";
	private String outputMdFormat = "EDM";

	@Override
	public void execute(final Engine engine, final NodeToken token) {
		String repoId = token.getFullEnv().getAttribute("repositoryId");
		if (repoId == null || repoId.trim().isEmpty())
			repoId = token.getFullEnv().getAttribute("repoId");

		log.info("FINDING TDS for repo " + repoId + " inputMdFormat: " + inputMdFormat + " outputMdFormat: " + outputMdFormat);

		final String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'TransformationDSResourceType' and .//REPOSITORY_SERVICE_IDENTIFIER = '"
				+ repoId + "' and  .//SOURCE_METADATA_FORMAT/@name='" + inputMdFormat + "' and .//SINK_METADATA_FORMAT/@name='" + outputMdFormat
				+ "']//RESOURCE_IDENTIFIER/@value/string()";
		try {
			String profId = this.lookupLocator.getService().getResourceProfileByQuery(query);
			final String xpath = "//LAST_UPDATE_STATUS";
			final String newNode = "<LAST_UPDATE_STATUS>" + status + "</LAST_UPDATE_STATUS>";
			this.registryLocator.getService().updateProfileNode(profId, xpath, newNode);

		} catch (Exception e) {
			failed(engine, token, e);
		}
		super.execute(engine, token);
	}

	public ServiceLocator<ISRegistryService> getRegistryLocator() {
		return registryLocator;
	}

	@Required
	public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
		this.registryLocator = registryLocator;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getInputMdFormat() {
		return inputMdFormat;
	}

	public void setInputMdFormat(String inputMdFormat) {
		this.inputMdFormat = inputMdFormat;
	}

	public String getOutputMdFormat() {
		return outputMdFormat;
	}

	public void setOutputMdFormat(String outputMdFormat) {
		this.outputMdFormat = outputMdFormat;
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}

	@Required
	public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}
}
