/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hadoop;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.manager.msro.hadoop.HopeTagTransformer;
import eu.dnetlib.workflow.AbstractJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class MergeTagsStarterJob
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(MergeTagsStarterJob.class);
    private String actionIfNotFound = "failed";
    private String mdstoreName = "mdstore";
    private String mdstoreSrc = "mdstoreSrc";
    private String mdstoreSink = "mdstoreSink";
    private String mongoHostName = "localhost";

    public void execute(Engine engine, NodeToken token) {
        Env env = token.getFullEnv();
        String mdstoreSrcName = env.getAttribute(this.mdstoreSrc);
        String mdstoreSinkName = env.getAttribute(this.mdstoreSink);
        if (mdstoreSinkName == null || mdstoreSinkName.isEmpty()) {
            mdstoreSinkName = this.mdstoreSink;
        }
        log.info((Object)"mdstores involved in m/r for tags:");
        log.info((Object)(mdstoreSrcName + " - " + mdstoreSinkName));
        try {
            ToolRunner.run((Configuration)new Configuration(), (Tool)new HopeTagTransformer(), (String[])new String[]{this.mdstoreName, mdstoreSrcName, mdstoreSinkName, this.mongoHostName});
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (Exception e1) {
            token.getEnv().setAttribute("hasFailed", (Object)true);
            token.getEnv().setAttribute("errorMessage", "Cannot run map reduce job: " + e1);
            log.warn((Object)"Cannot run map reduce job", (Throwable)e1);
            engine.complete(token, this.actionIfNotFound);
        }
    }

    public String getActionIfNotFound() {
        return this.actionIfNotFound;
    }

    public void setActionIfNotFound(String actionIfNotFound) {
        this.actionIfNotFound = actionIfNotFound;
    }

    public String getMdstoreName() {
        return this.mdstoreName;
    }

    public void setMdstoreName(String mdstoreName) {
        this.mdstoreName = mdstoreName;
    }

    public String getMdstoreSrc() {
        return this.mdstoreSrc;
    }

    public void setMdstoreSrc(String mdstoreSrc) {
        this.mdstoreSrc = mdstoreSrc;
    }

    public String getMdstoreSink() {
        return this.mdstoreSink;
    }

    public void setMdstoreSink(String mdstoreSink) {
        this.mdstoreSink = mdstoreSink;
    }

    public String getMongoHostName() {
        return this.mongoHostName;
    }

    public void setMongoHostName(String mongoHostName) {
        this.mongoHostName = mongoHostName;
    }
}

