/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.SAXException;

public class IterableXmlInputStreamParser
implements Iterable<String> {
    private final ThreadLocal<XMLInputFactory> inputFactory = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            return XMLInputFactory.newInstance();
        }
    };
    private final ThreadLocal<XMLOutputFactory> outputFactory = new ThreadLocal<XMLOutputFactory>(){

        @Override
        protected XMLOutputFactory initialValue() {
            return XMLOutputFactory.newInstance();
        }
    };
    private final ThreadLocal<XMLEventFactory> eventFactory = new ThreadLocal<XMLEventFactory>(){

        @Override
        protected XMLEventFactory initialValue() {
            return XMLEventFactory.newInstance();
        }
    };
    private final String element;
    private final InputStream inputStream;

    public IterableXmlInputStreamParser(String element, InputStream inputStream) {
        this.element = element;
        this.inputStream = inputStream;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            final XMLEventReader parser;
            private XMLEvent current;
            {
                this.parser = IterableXmlInputStreamParser.this.getParser();
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                try {
                    this.current = this.findElement(this.parser);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }

            @Override
            public String next() {
                try {
                    return this.copy(this.parser);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private String copy(XMLEventReader parser) throws XMLStreamException, SAXException, IOException {
                StringWriter result = new StringWriter();
                XMLEventWriter writer = ((XMLOutputFactory)IterableXmlInputStreamParser.this.outputFactory.get()).createXMLEventWriter(result);
                StartElement newRecord = ((XMLEventFactory)IterableXmlInputStreamParser.this.eventFactory.get()).createStartElement("", null, IterableXmlInputStreamParser.this.element, this.current.asStartElement().getAttributes(), this.current.asStartElement().getNamespaces());
                writer.add(newRecord);
                while (parser.hasNext()) {
                    XMLEvent event = parser.nextEvent();
                    if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(IterableXmlInputStreamParser.this.element)) {
                        writer.add(event);
                        break;
                    }
                    writer.add(event);
                }
                writer.close();
                String string = result.toString();
                return string;
            }

            private XMLEvent findElement(XMLEventReader parser) {
                XMLEvent peek = IterableXmlInputStreamParser.this.peekEvent(parser);
                if (peek != null && peek.isStartElement()) {
                    String name = peek.asStartElement().getName().getLocalPart();
                    if (IterableXmlInputStreamParser.this.element.equals(name)) {
                        return peek;
                    }
                }
                while (parser.hasNext()) {
                    XMLEvent event = IterableXmlInputStreamParser.this.nextEvent(parser);
                    if (event == null || !event.isStartElement()) continue;
                    String name = event.asStartElement().getName().getLocalPart();
                    if (!IterableXmlInputStreamParser.this.element.equals(name)) continue;
                    return event;
                }
                throw new IllegalArgumentException("cannot find element <" + IterableXmlInputStreamParser.this.element + ">");
            }
        };
    }

    private XMLEvent nextEvent(XMLEventReader parser) {
        try {
            return parser.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private XMLEvent peekEvent(XMLEventReader parser) {
        try {
            return parser.peek();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private XMLEventReader getParser() {
        try {
            return this.inputFactory.get().createXMLEventReader(this.inputStream);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }
}

