package eu.dnetlib.enabling.manager.msro.hope;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.pid.service.rmi.PIDAssignerService;
import eu.dnetlib.workflow.AbstractJobNode;

/**
 * JobNode to assign PIDs to records according to rules specified in a PIDRuleDSResources profile.
 * 
 * @author alessia
 * 
 */
public class AssignPIDsJob extends AbstractJobNode {

	private static final Log log = LogFactory.getLog(AssignPIDsJob.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * Name of the env attribute where to look for the metadata format.
	 */
	private String mdFormatAttributeName;
	/**
	 * Metadata format to use to look for rules. If not set, the job will look for it in the env via the attribute whose
	 * name is in the mdFormatAttributeName property.
	 */
	private String mdFormat;
	/**
	 * Name of the transient attribute in the env for the records source.
	 */
	private String srcEprAttributeName;
	/**
	 * Name of the env attribute where to look for the naming authority to be used for PID assignment.
	 */
	private String naAttributeName;
	/**
	 * Name of the env attribute where to store the pidded records' EPR.
	 */
	private String outputEprAttributeName = "piddedEpr";
	/**
	 * lookup locator.
	 */
	private ServiceLocator<ISLookUpService> lookupLocator;
	private ServiceLocator<PIDAssignerService> pidAssignerServiceLocator;

	@Override
	public void execute(Engine engine, NodeToken token) {
		String namingAuthority = token.getEnv().getAttribute(naAttributeName);
		final W3CEndpointReference srcEpr = (W3CEndpointReference) token.getEnv().getTransientAttribute(this.srcEprAttributeName);
		log.debug("srcEprAttributeName = " + srcEprAttributeName);
		log.debug("naAttributeName = " + this.naAttributeName + " ; NA = " + namingAuthority);
		//if there's no naming authority, then the CP is a PID Provider.
		if (namingAuthority != null && !namingAuthority.isEmpty()) {
			log.debug("*************************PID assignment execution**************");
			if (this.mdFormat == null || this.mdFormat.isEmpty())
				this.mdFormat = token.getEnv().getAttribute(mdFormatAttributeName);
			log.debug("mdFormat = " + this.mdFormat);
			log.debug("outputEprAttributeName = " + this.outputEprAttributeName);
			try {
				String ruleID = lookupLocator
						.getService()
						.quickSearchProfile(
								"//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'PIDRuleDSResourceType' and .//RESOURCE_KIND/@value = 'PIDRuleDSResources' and .//METADATA_FORMAT = '"
										+ mdFormat + "']//RESOURCE_IDENTIFIER/@value/string()").get(0);
				log.debug("Found rule id = " + ruleID);
				W3CEndpointReference outEpr = this.pidAssignerServiceLocator.getService().assignPIDs(srcEpr, ruleID, namingAuthority);

				token.getEnv().setAttribute(outputEprAttributeName + "String", outEpr.toString());
				token.getEnv().setTransientAttribute(outputEprAttributeName, outEpr);
			} catch (final Throwable e) {
				this.failed(engine, token, e);
				log.info("FAILED:::::::::" + e);
			}
		} else {
			log.debug("*************************NO PID assignment execution**************");
			token.getEnv().setAttribute(outputEprAttributeName + "String", srcEpr.toString());
			token.getEnv().setTransientAttribute(outputEprAttributeName, srcEpr);

		}
		log.debug("*****************************NODE DONE*****************************************************");
		super.execute(engine, token);
	}

	public void setMdFormatAttributeName(String mdFormatAttributeName) {
		this.mdFormatAttributeName = mdFormatAttributeName;
	}

	public String getMdFormatAttributeName() {
		return mdFormatAttributeName;
	}

	public String getMdFormat() {
		return mdFormat;
	}

	public void setMdFormat(String mdFormat) {
		this.mdFormat = mdFormat;
	}

	public String getSrcEprAttributeName() {
		return srcEprAttributeName;
	}

	public void setSrcEprAttributeName(String srcEprName) {
		this.srcEprAttributeName = srcEprName;
	}

	public String getNaAttributeName() {
		return naAttributeName;
	}

	public void setNaAttributeName(String naAttributeName) {
		this.naAttributeName = naAttributeName;
	}

	public void setOutputEprAttributeName(String outputEprAttributeName) {
		this.outputEprAttributeName = outputEprAttributeName;
	}

	@Required
	public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}

	@Required
	public void setPidAssignerServiceLocator(ServiceLocator<PIDAssignerService> pidAssignerServiceLocator) {
		this.pidAssignerServiceLocator = pidAssignerServiceLocator;
	}

	public ServiceLocator<PIDAssignerService> getPidAssignerServiceLocator() {
		return pidAssignerServiceLocator;
	}

	public String getOutputEprAttributeName() {
		return outputEprAttributeName;
	}

}
