package eu.dnetlib.enabling.manager.msro.hope;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;

public class ReindexHopeNotificationHandler extends AbstractReindexHopeNotificationHandler {

	private static final String STATUS_VALUE = "TAGGED";
	private static final Log log = LogFactory.getLog(ReindexHopeNotificationHandler.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.enabling.manager.msro.hope.AbstractReindexHopeNotificationHandler#obtainMdId(java.lang.String,
	 *      java.lang.String)
	 */
	@Override
	protected String obtainMdId(String rsId, String profile) throws ISLookUpDocumentNotFoundException, ISLookUpException {
		//rsId is the identifier of the TDS from hope to EDM (becasue of the subscription of this notification handler
		final String sourceQuery = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId + "']//DATA_SOURCE/text()";
		String datasource = this.getLookupLocator().getService().getResourceProfileByQuery(sourceQuery);
		return this.getSourceDescriptionGenerator().getParameters(datasource).getId();
	}

	@Override
	protected boolean mustStart(String topic, String profile, String rsId) {
		String topicPrefix = getTopicPrefix();
		if (!topic.startsWith(topicPrefix)) {
			log.debug("WF must not start because of missing topic prefix: " + topicPrefix);
			return false;
		}
		String xQueryStatus = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId + "']//LAST_UPDATE_STATUS/text()";
		try {
			String statusValue = this.getLookupLocator().getService().quickSearchProfile(xQueryStatus).get(0);
			if (statusValue.equals(STATUS_VALUE)) {
				return true;
			} else {
				log.debug("WF must not start because status value is : " + statusValue);
				return false;
			}

		} catch (ISLookUpException e) {
			log.debug("WF must not start because of lookup exception: " + e);
			return false;
		}
	}

}
