package eu.dnetlib.enabling.manager.msro.hope;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler;
import eu.dnetlib.enabling.tools.ServiceLocator;

/**
 * NotificationHandler for the TransformHopeRecords job.
 * 
 * @author alessia
 * 
 */
public class TransformHopeRecordsNotificationHandler extends AbstractWorkflowLauncherNotificationHandler {
	private static final Log log = LogFactory.getLog(TransformHopeRecordsNotificationHandler.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * locator.
	 */
	private ServiceLocator<ISLookUpService> lookupLocator;
	/**
	 * Used to create data source descriptors from MDStore id.
	 */
	@Resource
	protected MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator;

	/**
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler#prepareProcess(com.googlecode.sarasvati.GraphProcess,
	 *      com.googlecode.sarasvati.env.Env, java.lang.String, java.lang.String)
	 */
	@Override
	protected void prepareProcess(GraphProcess process, Env env, String rsId, String profile) {
		//rsId is the id of the mdstore which is the data source
		log.info("NotificationHandler to transform domain records into Hope records. rsId (mdStoreID) = " + rsId);

		try {
			String dataSource = sourceDescriptionGenerator.generateDataSourceDescriptor(rsId);

			String xquery = "//DATA_SINK" + "[" + "	../SINK_METADATA_FORMAT/@name='hope' and " + "	..//DATA_SOURCE = '" + dataSource + "']/text()";

			String dataSink = lookupLocator.getService().getResourceProfileByQuery(xquery);

			// TODO: use utility method for this query because it's used in UpdateRepositorySizeJob.java and ReindexNotificationHandler too
			final String query = "//RESOURCE_PROFILE[.//MDSTORE_DS_IDENTIFIER='" + rsId + "' or contains(.//DATA_SINK, '" + rsId
					+ "')]//REPOSITORY_SERVICE_IDENTIFIER/text()";
			
			final String repId = lookupLocator.getService().getResourceProfileByQuery(query);
			log.debug("got repository profile " + repId);
			env.setAttribute("repositoryId", repId);
			env.setAttribute("dataSource", dataSource);
			env.setAttribute("dataSink", dataSink);
			//this is for the FindTDSByMdFormats
			env.setAttribute("outputFormat", "hope");
			
			//need tdsId
			String tdsIdQuery = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'TransformationDSResourceType'" +
					" and .//DATA_SOURCE = '"+dataSource+"' and .//DATA_SINK = '"+dataSink+"']//RESOURCE_IDENTIFIER/@value/string()";
			String tdsId = lookupLocator.getService().getResourceProfileByQuery(tdsIdQuery);
			env.setAttribute("tdsId", tdsId);
		
		} catch (final ISLookUpDocumentNotFoundException e) {
			log.warn("cannot locate the repository associated with the mdstore " + rsId, e);
		} catch (final ISLookUpException e) {
			log.warn("cannot locate the repository associated with the mdstore " + rsId, e);
		}
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}

	@Required
	public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}
}
