package eu.dnetlib.enabling.manager.msro.hope;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler;
import eu.dnetlib.enabling.tools.ServiceLocator;

/**
 * NotificationHandler for the TransformLocalToDomain job. TODO: change this to set in the env the groovyClassPath and
 * the dnetGroovyClassName properties. groovyClassPath: path to the local folder containing the classes to be loaded for
 * the transformation. dnetGroovyClassName: name of the groovy class imlementing the DNetGroovyClass interface.
 * 
 * @author alessia
 * 
 */
public class TransformLocalToDomainNotificationHandler extends AbstractWorkflowLauncherNotificationHandler {
	private static final Log log = LogFactory.getLog(TransformLocalToDomainNotificationHandler.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * locator.
	 */
	private ServiceLocator<ISLookUpService> lookupLocator;

	/**
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler#prepareProcess(com.googlecode.sarasvati.GraphProcess,
	 *      com.googlecode.sarasvati.env.Env, java.lang.String, java.lang.String)
	 */
	@Override
	protected void prepareProcess(final GraphProcess process, final Env env, final String rsId, final String profile) {
		//rsId is the id of the TDS
		log.info("NotificationHandler to transform local records into domain records. rsId (TDS) = " + rsId);

		try {

			final String query = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId + "']//REPOSITORY_SERVICE_IDENTIFIER/text()";
			final String repId = this.lookupLocator.getService().getResourceProfileByQuery(query);
			log.debug("got repository profile " + repId);
			env.setAttribute("repositoryId", repId);

			final String queryGroovyConfig = "let $groovyID := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId
					+ "']//BODY/CONFIGURATION/TRANSFORMATION_RULE_DS_IDENTIFIER/string() "
					+ "let $groovyProfileConfig := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value=$groovyID]/BODY/CONFIGURATION "
					+ "return concat($groovyProfileConfig/GROOVY_CLASSPATH/text(),':-:', $groovyProfileConfig/GROOVY_DNETCLASS/text())";
			String configs = this.lookupLocator.getService().quickSearchProfile(queryGroovyConfig).get(0);
			log.debug("Groovy configs: " + configs);
			if (!configs.equals(":-:")) {
				log.debug("Groovy rule found");
				String[] configArray = configs.split(":-:");
				env.setAttribute("groovyClassPath", configArray[0]);
				env.setAttribute("dnetGroovyClassName", configArray[1]);
			} else {
				log.debug("No groovy rule to apply");
			}

		} catch (final ISLookUpDocumentNotFoundException e) {
			log.warn("cannot locate the repository associated with the TDS " + rsId, e);
		} catch (final ISLookUpException e) {
			log.warn("cannot locate the repository associated with the TDS " + rsId, e);
		}
	}

	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return this.lookupLocator;
	}

	@Required
	public void setLookupLocator(final ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}
}
