package eu.dnetlib.enabling.manager.msro.hope;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.utility.objectpackaging.rmi.ObjectPackagingException;
import eu.dnetlib.data.utility.objectpackaging.rmi.ObjectPackagingService;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;

public class UnpackageHopeRecords extends AbstractJobNode {

	private static final Log log = LogFactory.getLog(UnpackageHopeRecords.class);
	/**
	 * {@link ResultSetClientFactory}
	 */
	@Resource
	private ResultSetClientFactory resultSetClientFactory;
	@Resource
	private IterableResultSetFactory iterableResultSetFactory;
	private ServiceLocator<ObjectPackagingService> objectpackLocator;

	@Override
	public void execute(final Engine engine, final NodeToken token) {
		log.debug("Unpackaging Hope records");
		W3CEndpointReference packagedEpr = (W3CEndpointReference) token.getEnv().getTransientAttribute("packagedEpr");

		if (packagedEpr == null) {
			failed(engine, token, new NullPointerException("packagedEpr is null"));
		}

		try {
			W3CEndpointReference hopeEpr = objectpackLocator.getService().splitPackages(packagedEpr);
			token.getEnv().setAttribute("hopeEprString", hopeEpr.toString());
			token.getEnv().setTransientAttribute("hopeEpr", hopeEpr);
			log.warn("Hope epr " + hopeEpr.toString());
		} catch (ObjectPackagingException e) {
			failed(engine, token, new NullPointerException("packagedEpr is null"));
		}

		//		List<Iterable<String>> resList = Lists.newArrayList();
		//		IterableResultSetClient rsClient = this.resultSetClientFactory.getClient(packagedEpr);
		//		for (String objRecord : rsClient) {
		//			InputStream in = IOUtils.toInputStream(objRecord);
		//			IterableXmlInputStreamParser parser = new IterableXmlInputStreamParser("record", in);
		//			resList.add(parser);
		//		}
		//		log.debug("input epr iterated, now building the output hope epr");
		//		W3CEndpointReference hopeEpr = this.iterableResultSetFactory.createIterableResultSet(Iterables.concat(resList));
		//		token.getEnv().setAttribute("hopeEprString", hopeEpr.toString());
		//		token.getEnv().setTransientAttribute("hopeEpr", hopeEpr);
		//		log.warn("Hope epr " + hopeEpr.toString());
		super.execute(engine, token);
	}

	public ResultSetClientFactory getRsClientFactory() {
		return resultSetClientFactory;
	}

	public void setRsClientFactory(ResultSetClientFactory rsClientFactory) {
		this.resultSetClientFactory = rsClientFactory;
	}

	public IterableResultSetFactory getIterableRsFactory() {
		return iterableResultSetFactory;
	}

	public void setIterableRsFactory(IterableResultSetFactory iterableRsFactory) {
		this.iterableResultSetFactory = iterableRsFactory;
	}

	public ServiceLocator<ObjectPackagingService> getObjectpackLocator() {
		return objectpackLocator;
	}

	public void setObjectpackLocator(ServiceLocator<ObjectPackagingService> objectpackLocator) {
		this.objectpackLocator = objectpackLocator;
	}

}
