package eu.dnetlib.enabling.manager.msro.hope.groovy;

import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.collect.Lists;

import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.push.PushResultSet;

public class DNetGroovyEnablerImpl implements DNetGroovyEnabler {

	private static final Log log = LogFactory.getLog(DNetGroovyEnablerImpl.class); // NOPMD by marko on 11/24/08 5:02 PM

	private static String SENTINEL = "END";
	private static String FAIL_SENTINEL = "FAIL";
	private W3CEndpointReference inputEPR;
	@Resource
	private ResultSetClientFactory resultSetClientFactory;
	private PushResultSet pushResultSet;
	private BlockingQueue<String> resultsQueue = new ArrayBlockingQueue<String>(100);
	private BlockingQueue<String> inputQueue = new ArrayBlockingQueue<String>(100);
	private RunnableGroovy runnableGroovy;
	private String repoId;

	@Override
	public void run() {
		this.runnableGroovy.setResultsQueue(resultsQueue);
		this.runnableGroovy.setInputQueue(inputQueue);
		this.runnableGroovy.setRepositoryId(repoId);
		Thread t = new Thread(runnableGroovy);
		log.info("Now feeding the groovy script with the epr via the input queue..");
		final Iterator<String> inputs = this.resultSetClientFactory.getClient(inputEPR).iterator();
		int c = 0;
		try {
			t.start();
			Thread insertor = new Thread(new Runnable() {
				@Override
				public void run() {
					log.info("Inserting elements in the queue for groovy...");
					try {
						while (inputs.hasNext())
							inputQueue.put(inputs.next());
						inputQueue.put(SENTINEL);
						log.info("Inserting elements in the queue for groovy... DONE");
					} catch (InterruptedException ie) {
						log.fatal("InterruptedException inserting in the queue for groovy");
						throw new RuntimeException(ie);
					}
				}
			});
			insertor.start();

			String res = "";
			log.info("Reading groovy results from the queue...");
			while (!(res = this.resultsQueue.take()).equals(SENTINEL)) {
				if (res.equals(FAIL_SENTINEL)) {
					this.pushResultSet.close();
					throw new RuntimeException("Groovy failure");
				}
				this.pushResultSet.addElements(Lists.newArrayList(res));
				c++;
			}
			log.info("pushed " + c + " elements in push RS");
		} catch (InterruptedException e) {
			log.debug("InterruptedException inserting in / taking from the queue");
			this.pushResultSet.close();
			throw new RuntimeException(e);
		}
		//read sentinel from queue --> close the RS
		log.debug("RS before closing it is open: " + this.pushResultSet.isOpen());
		this.pushResultSet.close();
		log.info("Results all pushed to the result set");
	}

	@Override
	public void setInputEPR(W3CEndpointReference epr) {
		this.inputEPR = epr;

	}

	@Override
	public void setResultSetClientFactory(ResultSetClientFactory client) {
		this.resultSetClientFactory = client;

	}

	@Override
	public void setPushResultSet(PushResultSet pushRS) {
		this.pushResultSet = pushRS;

	}

	public BlockingQueue<String> getResultsQueue() {
		return resultsQueue;
	}

	public void setResultsQueue(BlockingQueue<String> resultsQueue) {
		this.resultsQueue = resultsQueue;
	}

	public W3CEndpointReference getInputEPR() {
		return inputEPR;
	}

	public ResultSetClientFactory getResultSetClientFactory() {
		return resultSetClientFactory;
	}

	public PushResultSet getPushResultSet() {
		return pushResultSet;
	}

	public RunnableGroovy getRunnableGroovy() {
		return runnableGroovy;
	}

	@Override
	public void setRunnableGroovy(RunnableGroovy runnableGroovy) {
		this.runnableGroovy = runnableGroovy;
	}

	public BlockingQueue<String> getInputQueue() {
		return inputQueue;
	}

	public void setInputQueue(BlockingQueue<String> inputQueue) {
		this.inputQueue = inputQueue;
	}

	public String getRepoId() {
		return repoId;
	}

	public void setRepoId(String repoId) {
		this.repoId = repoId;
	}

}
