<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
    xmlns:oai="http://www.openarchives.org/OAI/2.0/"
    exclude-result-prefixes="xsl datetime exslt xsi" xmlns:dri="http://www.driver-repository.eu/namespace/dri">
    
    <xsl:param name="repoId" />
    <xsl:param name="inputFormat" />
    
    <xsl:template match="/">
        <xsl:choose>
            <xsl:when test="//*[local-name() = 'record']/*[local-name()='header']">
                <xsl:apply-templates mode="isOAI" />
            </xsl:when>
            <xsl:otherwise>
                <record>
                    <header>
                        <xsl:variable name="id">
                            <xsl:call-template name="getIdentifier" />
                        </xsl:variable>
                        <identifier>
                            <xsl:value-of select="$id" />
                        </identifier>
                        <dri:repositoryId>
                            <xsl:value-of select="$repoId" />
                        </dri:repositoryId>
                        <dri:objIdentifier>
                            <xsl:value-of select="concat($repoId, '::', $id)" />
                        </dri:objIdentifier>
                        <dri:dateOfCollection>
                            <xsl:value-of select="datetime:dateTime()" />
                        </dri:dateOfCollection>
                    </header>
                    <metadata>
                        <xsl:apply-templates mode="nonOAI" />
                    </metadata>
                </record>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- isOAI mode templates: adds dri fields to the OAI header -->
    
    <xsl:template match="@*|*" mode="isOAI">
        <xsl:copy>
            <xsl:apply-templates select="@*|*|text()" mode="isOAI" />
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="*[local-name()='header']" mode="isOAI">
        <header> 
            <dri:objIdentifier>
                <xsl:value-of select="concat($repoId, '::', normalize-space(//*[local-name() = 'header']/*[local-name() = 'identifier']))" />
            </dri:objIdentifier>
            <dri:dateOfCollection>
                <xsl:value-of select="datetime:dateTime()" />
            </dri:dateOfCollection>
            <dri:repositoryId>
                <xsl:value-of select="$repoId" />
            </dri:repositoryId>
            
            <xsl:apply-templates mode="isOAI" />
        </header>
    </xsl:template>
    
    <!-- nonOAI mode templates: turns a non-OAI record into an OAI record -->
    <xsl:template match="@*|*" mode="nonOAI">
        <xsl:copy>
            <xsl:apply-templates select="@*|*|text()" mode="isOAI" />
        </xsl:copy>
    </xsl:template>
    
    <!-- gets the identifier of the current ingested file based on the input 
		md format -->
    <xsl:template name="getIdentifier" mode="nonOAI">
        <xsl:choose>
            <xsl:when test="$inputFormat = string('AdsD')">
                <xsl:value-of select="substring-before(//Signatur[1], '/')" />
            </xsl:when>
            <xsl:when test="$inputFormat = string('lido')">
                <xsl:value-of
                    select="//*[local-name() = 'lido']/*[local-name() = 'lidoRecID'][1]" />
            </xsl:when>
            <xsl:when test="$inputFormat = string('marc')">
                <xsl:value-of
                    select="/*[local-name() ='record']/*[local-name() = 'controlfield' and @*[local-name()='tag'] ='001']" />
            </xsl:when>
            <xsl:when test="$inputFormat = string('ead')">
                <xsl:value-of
                    select="/*[local-name() = 'ead']/*[local-name() = 'eadheader']/*[local-name() = 'eadid']" />
            </xsl:when>
            <xsl:when test="$inputFormat = string('mods')">
                <xsl:value-of
                    select="//*[local-name() = 'mods'][1]/*[local-name() = 'identifier'][1]" />
            </xsl:when>
            <xsl:when test="$inputFormat = string('dc')">
                <xsl:value-of select="//*[local-name() = 'identifier'][1]" />
            </xsl:when>
            <xsl:when test="$inputFormat = string('ImagicXML')">
                <xsl:value-of select="/ImagicXML/Update/@TimeStamp" />
            </xsl:when>
            <xsl:when test="$inputFormat = string('ead_c_only')">
                <xsl:value-of
                    select="/*[local-name() = 'c'][1]//*[local-name() = 'unitid'][1]" />
            </xsl:when>
        </xsl:choose>
        
    </xsl:template>
    
    
</xsl:stylesheet>
