/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hadoop;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.bson.BSONObject;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class HopeEDMMapper
extends Mapper<Object, BSONObject, Text, Text> {
    private static final Log log = LogFactory.getLog(HopeEDMMapper.class);
    private final Text mapValue = new Text();
    private final Text mapKey = new Text();

    public void map(Object key, BSONObject value, Mapper.Context context) throws IOException, InterruptedException {
        String bodyContent = value.get("body").toString();
        SAXReader sr = new SAXReader();
        try {
            Document doc = sr.read((Reader)new StringReader(bodyContent));
            String entityType = doc.valueOf("local-name(//hopeEntity/*[last()])");
            if (entityType.equals("digitalResource")) {
                String dr = doc.valueOf("//digitalResource/represents/@persistentID");
                if (dr.startsWith("http")) {
                    this.mapKey.set(dr);
                    log.debug((Object)("Found dr linked to: " + dr));
                    this.mapValue.set(bodyContent);
                    context.write((Object)this.mapKey, (Object)this.mapValue);
                } else {
                    log.info((Object)("Found dr whose du has a non-PID identifier (" + dr + ") ...dr skipped"));
                }
            } else if (entityType.equals("descriptiveUnit")) {
                String du = doc.valueOf("//hopeEntity/persistentID");
                if (du.startsWith("http")) {
                    this.mapKey.set(du);
                    log.debug((Object)("Found du with persistentID: " + du));
                    this.mapValue.set(bodyContent);
                    context.write((Object)this.mapKey, (Object)this.mapValue);
                } else {
                    log.info((Object)("Found du with a non-PID identifier...du " + du + " skipped"));
                }
            }
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }
}

