/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hadoop;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;

public class HopeEDMReducer
extends Reducer<Text, Text, Text, Text> {
    private final Text result = new Text();
    private final TransformerFactory factory = TransformerFactory.newInstance();

    public void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        String repoId = context.getConfiguration().get("repoId");
        String xsltCode = context.getConfiguration().get("xsltCode");
        Element item = DocumentHelper.createElement((String)"objectRecord");
        Document d = DocumentHelper.createDocument((Element)item);
        SAXReader sr = new SAXReader();
        try {
            for (Text val : values) {
                Document doc = sr.read((Reader)new StringReader(val.toString()));
                item.add(doc.getRootElement());
            }
            DocumentResult output = new DocumentResult();
            DocumentSource source = new DocumentSource(d);
            Transformer transformer = this.factory.newTransformer(new StreamSource(new StringReader(xsltCode)));
            transformer.setOutputProperty("indent", "yes");
            transformer.setParameter("repoId", repoId);
            transformer.setParameter("objId", key.toString());
            transformer.transform((Source)source, (Result)output);
            this.result.set(output.getDocument().asXML());
            context.write((Object)key, (Object)this.result);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }
}

