/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hadoop;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class HopeTagReducer
extends Reducer<Text, Text, Text, Text> {
    private static final Log log = LogFactory.getLog(HopeTagReducer.class);
    private final Text result = new Text();
    private final SAXReader saxReader = new SAXReader();

    public SAXReader getSaxReader() {
        return this.saxReader;
    }

    public void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        Document doc = null;
        ArrayList themeTags = Lists.newArrayList();
        ArrayList exportTags = Lists.newArrayList();
        for (Text value : values) {
            String val = value.toString();
            if (val.startsWith("theme")) {
                themeTags.add(val.split("::-::")[1]);
                continue;
            }
            if (val.startsWith("export")) {
                exportTags.add(val.split("::-::")[1]);
                continue;
            }
            try {
                doc = this.saxReader.read((Reader)new StringReader(value.toString()));
            }
            catch (DocumentException e) {
                throw new RuntimeException("Can't read input value: " + value.toString());
            }
        }
        this.fillRecordWithThemes(doc, themeTags);
        this.fillRecordWithExports(doc, exportTags);
        String recordXML = doc.asXML();
        this.result.set(recordXML);
        context.write((Object)key, (Object)this.result);
    }

    protected void fillRecordWithThemes(Document doc, List<String> themes) {
        Node duNode = doc.selectSingleNode("//descriptiveUnit");
        if (duNode == null) {
            return;
        }
        List themeNodes = doc.selectNodes("//associatedHopeTheme");
        for (Node themeNode : themeNodes) {
            themeNode.detach();
        }
        log.debug((Object)"Now doc should have no <associatedHopeTheme>: ");
        log.debug((Object)doc.asXML());
        if (!themes.isEmpty()) {
            for (String theme : themes) {
                Element el = (Element)duNode;
                el.addElement("associatedHopeTheme").addText(theme);
            }
        }
    }

    protected void fillRecordWithExports(Document doc, List<String> exports) {
        Node drNode = doc.selectSingleNode("//digitalResource");
        if (drNode == null) {
            return;
        }
        Node miscNode = doc.selectSingleNode("//misc");
        if (miscNode == null) {
            miscNode = ((Element)drNode).addElement("misc");
        } else {
            List exportTagNodes = doc.selectNodes("//misc/miscfield[./key/text()='exportTag']");
            for (Node exportTagNode : exportTagNodes) {
                exportTagNode.detach();
            }
        }
        log.debug((Object)"Now doc should have no export tags: ");
        log.debug((Object)doc.asXML());
        for (String exp : exports) {
            Element miscField = ((Element)miscNode).addElement("miscfield");
            miscField.addElement("key").addText("exportTag");
            miscField.addElement("value").addText(exp);
        }
    }
}

