/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hadoop;

import com.mongodb.hadoop.MongoInputFormat;
import com.mongodb.hadoop.util.MongoConfigUtil;
import eu.dnetlib.enabling.manager.msro.hadoop.HopeTagMapper;
import eu.dnetlib.enabling.manager.msro.hadoop.HopeTagReducer;
import eu.dnetlib.enabling.manager.msro.hadoop.MDStoreOutputFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;

public class HopeTagTransformer
extends Configured
implements Tool {
    private static final Log log = LogFactory.getLog(HopeTagTransformer.class);

    public int run(String[] args) throws Exception {
        Configuration conf = new Configuration();
        String mdstoreName = args[0];
        String mongoHostName = args[3];
        MongoConfigUtil.setInputURI((Configuration)conf, (String)("mongodb://" + mongoHostName + "/" + mdstoreName + "." + args[1]));
        MongoConfigUtil.setOutputURI((Configuration)conf, (String)("mongodb://" + mongoHostName + "/" + mdstoreName + "." + args[2]));
        Job job = new Job(conf, "tag transformer job");
        job.setMapperClass(HopeTagMapper.class);
        job.setReducerClass(HopeTagReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormatClass(MongoInputFormat.class);
        job.setOutputFormatClass(MDStoreOutputFormat.class);
        long start = new Date().getTime();
        job.waitForCompletion(true);
        long end = new Date().getTime();
        log.info((Object)("MAP/REDUCE JOB completed in " + (end - start) / 1000L + " seconds"));
        return 0;
    }
}

