/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;
import com.googlecode.sarasvati.mem.MemGraphProcess;
import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractReindexHopeNotificationHandler
extends AbstractWorkflowLauncherNotificationHandler {
    private static final Log log = LogFactory.getLog(AbstractReindexHopeNotificationHandler.class);
    @Resource
    private MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator;
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String layout;

    protected abstract String obtainMdId(String var1, String var2) throws ISLookUpDocumentNotFoundException, ISLookUpException;

    protected abstract boolean mustStart(String var1, String var2, String var3);

    public void notified(String subscrId, String topic, String rsId, String profile) {
        log.debug((Object)(((Object)((Object)this)).getClass() + " notified. ID subscription: " + subscrId));
        if (!this.mustStart(topic, profile, rsId)) {
            return;
        }
        MemGraphProcess process = new MemGraphProcess(this.getGraph());
        this.getProcessRegistry().associateProcessWithResource((GraphProcess)process, rsId);
        Env env = process.getEnv();
        env.setAttribute("enableableName", this.getEnableableName());
        log.debug((Object)("Starting workflow process for " + this.getEnableableName()));
        try {
            this.prepareProcess((GraphProcess)process, env, rsId, profile);
        }
        catch (RuntimeException e) {
            env.setAttribute("hasFailed", (Object)true);
            env.setAttribute("errorMessage", e.getMessage());
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTrace));
            env.setAttribute("errorDetails", stackTrace.toString());
            throw e;
        }
        this.getEngine().startProcess((GraphProcess)process);
    }

    public void prepareProcess(GraphProcess process, Env env, String rsId, String profile) {
        log.debug((Object)("rsId: " + rsId));
        log.debug((Object)("profile: " + profile));
        try {
            String mdId = this.obtainMdId(rsId, profile);
            this.getProcessRegistry().associateProcessWithResource(process, mdId);
            String query = "//RESOURCE_PROFILE[.//MDSTORE_DS_IDENTIFIER='" + mdId + "' or contains(.//DATA_SINK, '" + mdId + "')]" + "//REPOSITORY_SERVICE_IDENTIFIER/text()";
            String repId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
            this.getProcessRegistry().associateProcessWithResource(process, repId);
            env.setAttribute("repoId", repId);
            String combinedQuery = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + mdId + "']//METADATA_FORMAT/text()," + "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + mdId + "']//METADATA_FORMAT_INTERPRETATION/text()";
            List combined = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(combinedQuery);
            env.setAttribute("dataSource", this.getSourceDescriptionGenerator().generateDataSourceDescriptor(mdId));
            env.setAttribute("mdId", mdId);
            env.setAttribute("format", (String)combined.get(0));
            env.setAttribute("interpretation", (String)combined.get(1));
            env.setAttribute("layout", this.getLayout());
            env.setAttribute("profileTDS", profile);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            throw new IllegalStateException("cannot re-index", e);
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException("cannot re-index", e);
        }
    }

    @Required
    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getLayout() {
        return this.layout;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public void setSourceDescriptionGenerator(MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator) {
        this.sourceDescriptionGenerator = sourceDescriptionGenerator;
    }

    public MDStoreDataSinkSourceDescriptorGenerator getSourceDescriptionGenerator() {
        return this.sourceDescriptionGenerator;
    }
}

