/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.pid.service.rmi.PIDAssignerService;
import eu.dnetlib.workflow.AbstractJobNode;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class AssignPIDsJob
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(AssignPIDsJob.class);
    private String mdFormatAttributeName;
    private String mdFormat;
    private String srcEprAttributeName;
    private String naAttributeName;
    private String outputEprAttributeName = "piddedEpr";
    private ServiceLocator<ISLookUpService> lookupLocator;
    private ServiceLocator<PIDAssignerService> pidAssignerServiceLocator;

    public void execute(Engine engine, NodeToken token) {
        String namingAuthority = token.getEnv().getAttribute(this.naAttributeName);
        W3CEndpointReference srcEpr = (W3CEndpointReference)token.getEnv().getTransientAttribute(this.srcEprAttributeName);
        log.debug((Object)("srcEprAttributeName = " + this.srcEprAttributeName));
        log.debug((Object)("naAttributeName = " + this.naAttributeName + " ; NA = " + namingAuthority));
        if (namingAuthority != null && !namingAuthority.isEmpty()) {
            log.debug((Object)"*************************PID assignment execution**************");
            if (this.mdFormat == null || this.mdFormat.isEmpty()) {
                this.mdFormat = token.getEnv().getAttribute(this.mdFormatAttributeName);
            }
            log.debug((Object)("mdFormat = " + this.mdFormat));
            log.debug((Object)("outputEprAttributeName = " + this.outputEprAttributeName));
            try {
                String ruleID = (String)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'PIDRuleDSResourceType' and .//RESOURCE_KIND/@value = 'PIDRuleDSResources' and .//METADATA_FORMAT = '" + this.mdFormat + "']//RESOURCE_IDENTIFIER/@value/string()").get(0);
                log.debug((Object)("Found rule id = " + ruleID));
                W3CEndpointReference outEpr = ((PIDAssignerService)this.pidAssignerServiceLocator.getService()).assignPIDs(srcEpr, ruleID, namingAuthority);
                token.getEnv().setAttribute(this.outputEprAttributeName + "String", outEpr.toString());
                token.getEnv().setTransientAttribute(this.outputEprAttributeName, (Object)outEpr);
            }
            catch (Throwable e) {
                this.failed(engine, token, e);
                log.info((Object)("FAILED:::::::::" + e));
            }
        } else {
            log.debug((Object)"*************************NO PID assignment execution**************");
            token.getEnv().setAttribute(this.outputEprAttributeName + "String", srcEpr.toString());
            token.getEnv().setTransientAttribute(this.outputEprAttributeName, (Object)srcEpr);
        }
        log.debug((Object)"*****************************NODE DONE*****************************************************");
        super.execute(engine, token);
    }

    public void setMdFormatAttributeName(String mdFormatAttributeName) {
        this.mdFormatAttributeName = mdFormatAttributeName;
    }

    public String getMdFormatAttributeName() {
        return this.mdFormatAttributeName;
    }

    public String getMdFormat() {
        return this.mdFormat;
    }

    public void setMdFormat(String mdFormat) {
        this.mdFormat = mdFormat;
    }

    public String getSrcEprAttributeName() {
        return this.srcEprAttributeName;
    }

    public void setSrcEprAttributeName(String srcEprName) {
        this.srcEprAttributeName = srcEprName;
    }

    public String getNaAttributeName() {
        return this.naAttributeName;
    }

    public void setNaAttributeName(String naAttributeName) {
        this.naAttributeName = naAttributeName;
    }

    public void setOutputEprAttributeName(String outputEprAttributeName) {
        this.outputEprAttributeName = outputEprAttributeName;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setPidAssignerServiceLocator(ServiceLocator<PIDAssignerService> pidAssignerServiceLocator) {
        this.pidAssignerServiceLocator = pidAssignerServiceLocator;
    }

    public ServiceLocator<PIDAssignerService> getPidAssignerServiceLocator() {
        return this.pidAssignerServiceLocator;
    }

    public String getOutputEprAttributeName() {
        return this.outputEprAttributeName;
    }
}

