/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.data.utility.cleaner.rmi.CleanerService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.workflow.AbstractJobNode;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class CleanHopeRecords
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(CleanHopeRecords.class);
    private ServiceResolver serviceResolver;
    private ServiceLocator<CleanerService> cleanerLocator;
    private String cleaningRule;
    private DataSourceResolver dataSourceResolver;

    public void execute(Engine engine, NodeToken token) {
        log.info((Object)"cleaning hope records");
        try {
            String dataSource = token.getFullEnv().getAttribute("dataSource");
            W3CEndpointReference nativeEpr = this.dataSourceResolver.resolve(dataSource).retrieve();
            W3CEndpointReference cleanedEpr = ((CleanerService)this.cleanerLocator.getService()).cleanInContext(nativeEpr, this.cleaningRule, null);
            Env env = token.getEnv();
            env.setAttribute("native_epr_string", nativeEpr.toString());
            env.setAttribute("cleaned_epr_string", cleanedEpr.toString());
            env.setTransientAttribute("native_epr", (Object)nativeEpr);
            env.setTransientAttribute("cleaned_epr", (Object)cleanedEpr);
            log.warn((Object)("cleaned epr " + cleanedEpr.toString()));
        }
        catch (Throwable e) {
            this.failed(engine, token, e);
        }
        super.execute(engine, token);
    }

    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    @Required
    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    public ServiceLocator<CleanerService> getCleanerLocator() {
        return this.cleanerLocator;
    }

    @Required
    public void setCleanerLocator(ServiceLocator<CleanerService> cleanerLocator) {
        this.cleanerLocator = cleanerLocator;
    }

    public String getCleaningRule() {
        return this.cleaningRule;
    }

    @Required
    public void setCleaningRule(String cleaningRule) {
        this.cleaningRule = cleaningRule;
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    @Required
    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }
}

