/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.DataSinkResolver;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.enabling.resultset.WorkflowCountingResultSetFactory;
import eu.dnetlib.workflow.AbstractJobNode;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class MergeMDStoresJob
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(MergeMDStoresJob.class);
    private DataSourceResolver dataSourceResolver;
    private DataSinkResolver dataSinkResolver;
    private WorkflowCountingResultSetFactory countingRSFactory;
    private String dataSourceAttributeName = "dataSource";
    private String targetStoreID = "targetStoreID";

    public void execute(Engine engine, NodeToken token) {
        try {
            String dataSource = token.getFullEnv().getAttribute(this.dataSourceAttributeName);
            String sinkID = token.getFullEnv().getAttribute(this.targetStoreID);
            W3CEndpointReference epr = this.dataSourceResolver.resolve(dataSource).retrieve();
            this.dataSinkResolver.resolve(new MDStoreDataSinkSourceDescriptorGenerator().generateDataSinkDescriptor(sinkID, "INCREMENTAL")).store(this.countingRSFactory.createCountingResultSet(epr, token));
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
        super.execute(engine, token);
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    @Required
    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }

    public DataSinkResolver getDataSinkResolver() {
        return this.dataSinkResolver;
    }

    @Required
    public void setDataSinkResolver(DataSinkResolver dataSinkResolver) {
        this.dataSinkResolver = dataSinkResolver;
    }

    public WorkflowCountingResultSetFactory getCountingRSFactory() {
        return this.countingRSFactory;
    }

    @Required
    public void setCountingRSFactory(WorkflowCountingResultSetFactory countingRSFactory) {
        this.countingRSFactory = countingRSFactory;
    }

    public String getDataSourceAttributeName() {
        return this.dataSourceAttributeName;
    }

    public void setDataSourceAttributeName(String dataSourceAttributeName) {
        this.dataSourceAttributeName = dataSourceAttributeName;
    }

    public String getTargetStoreID() {
        return this.targetStoreID;
    }

    public void setTargetStoreID(String targetStoreID) {
        this.targetStoreID = targetStoreID;
    }
}

