/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.hope.AbstractReindexHopeNotificationHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReindexHopeNotificationHandler
extends AbstractReindexHopeNotificationHandler {
    private static final String STATUS_VALUE = "TAGGED";
    private static final Log log = LogFactory.getLog(ReindexHopeNotificationHandler.class);

    @Override
    protected String obtainMdId(String rsId, String profile) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        String sourceQuery = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId + "']//DATA_SOURCE/text()";
        String datasource = ((ISLookUpService)this.getLookupLocator().getService()).getResourceProfileByQuery(sourceQuery);
        return this.getSourceDescriptionGenerator().getParameters(datasource).getId();
    }

    @Override
    protected boolean mustStart(String topic, String profile, String rsId) {
        String topicPrefix = this.getTopicPrefix();
        if (!topic.startsWith(topicPrefix)) {
            log.debug((Object)("WF must not start because of missing topic prefix: " + topicPrefix));
            return false;
        }
        String xQueryStatus = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + rsId + "']//LAST_UPDATE_STATUS/text()";
        try {
            String statusValue = (String)((ISLookUpService)this.getLookupLocator().getService()).quickSearchProfile(xQueryStatus).get(0);
            if (statusValue.equals(STATUS_VALUE)) {
                return true;
            }
            log.debug((Object)("WF must not start because status value is : " + statusValue));
            return false;
        }
        catch (ISLookUpException e) {
            log.debug((Object)("WF must not start because of lookup exception: " + (Object)((Object)e)));
            return false;
        }
    }
}

