/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.utility.objectpackaging.rmi.ObjectPackagingException;
import eu.dnetlib.data.utility.objectpackaging.rmi.ObjectPackagingService;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnpackageHopeRecords
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(UnpackageHopeRecords.class);
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    @Resource
    private IterableResultSetFactory iterableResultSetFactory;
    private ServiceLocator<ObjectPackagingService> objectpackLocator;

    public void execute(Engine engine, NodeToken token) {
        log.debug((Object)"Unpackaging Hope records");
        W3CEndpointReference packagedEpr = (W3CEndpointReference)token.getEnv().getTransientAttribute("packagedEpr");
        if (packagedEpr == null) {
            this.failed(engine, token, new NullPointerException("packagedEpr is null"));
        }
        try {
            W3CEndpointReference hopeEpr = ((ObjectPackagingService)this.objectpackLocator.getService()).splitPackages(packagedEpr);
            token.getEnv().setAttribute("hopeEprString", hopeEpr.toString());
            token.getEnv().setTransientAttribute("hopeEpr", (Object)hopeEpr);
            log.warn((Object)("Hope epr " + hopeEpr.toString()));
        }
        catch (ObjectPackagingException e) {
            this.failed(engine, token, new NullPointerException("packagedEpr is null"));
        }
        super.execute(engine, token);
    }

    public ResultSetClientFactory getRsClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setRsClientFactory(ResultSetClientFactory rsClientFactory) {
        this.resultSetClientFactory = rsClientFactory;
    }

    public IterableResultSetFactory getIterableRsFactory() {
        return this.iterableResultSetFactory;
    }

    public void setIterableRsFactory(IterableResultSetFactory iterableRsFactory) {
        this.iterableResultSetFactory = iterableRsFactory;
    }

    public ServiceLocator<ObjectPackagingService> getObjectpackLocator() {
        return this.objectpackLocator;
    }

    public void setObjectpackLocator(ServiceLocator<ObjectPackagingService> objectpackLocator) {
        this.objectpackLocator = objectpackLocator;
    }
}

