/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class UpdateTDSStatusJob
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(UpdateTDSStatusJob.class);
    private ServiceLocator<ISRegistryService> registryLocator;
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String status = "TAGGED";
    private String inputMdFormat = "hope";
    private String outputMdFormat = "EDM";

    public void execute(Engine engine, NodeToken token) {
        String repoId = token.getFullEnv().getAttribute("repositoryId");
        if (repoId == null || repoId.trim().isEmpty()) {
            repoId = token.getFullEnv().getAttribute("repoId");
        }
        log.info((Object)("FINDING TDS for repo " + repoId + " inputMdFormat: " + this.inputMdFormat + " outputMdFormat: " + this.outputMdFormat));
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'TransformationDSResourceType' and .//REPOSITORY_SERVICE_IDENTIFIER = '" + repoId + "' and  .//SOURCE_METADATA_FORMAT/@name='" + this.inputMdFormat + "' and .//SINK_METADATA_FORMAT/@name='" + this.outputMdFormat + "']//RESOURCE_IDENTIFIER/@value/string()";
        try {
            String profId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
            String xpath = "//LAST_UPDATE_STATUS";
            String newNode = "<LAST_UPDATE_STATUS>" + this.status + "</LAST_UPDATE_STATUS>";
            ((ISRegistryService)this.registryLocator.getService()).updateProfileNode(profId, "//LAST_UPDATE_STATUS", newNode);
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
        super.execute(engine, token);
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getInputMdFormat() {
        return this.inputMdFormat;
    }

    public void setInputMdFormat(String inputMdFormat) {
        this.inputMdFormat = inputMdFormat;
    }

    public String getOutputMdFormat() {
        return this.outputMdFormat;
    }

    public void setOutputMdFormat(String outputMdFormat) {
        this.outputMdFormat = outputMdFormat;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

