/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.hope.thumbnails;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.manager.msro.hope.thumbnails.ThumbnailInfo;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.workflow.AbstractJobNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;

public class FindOriginalFiles
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(FindOriginalFiles.class);
    private String endpoint;
    private String thumbnailHost;
    private String query;
    private int pageSize = 100;
    private final Gson gson = new Gson();
    private final String returnedFields = "derivative2,derivative3url";
    @Resource
    private IterableResultSetFactory iterableResultSetFactory;

    public void execute(Engine engine, NodeToken token) {
        this.query = "derivative3url:http\\:\\/\\/localhost*";
        try {
            int start = 0;
            int processed = -1;
            int totalMatches = 0;
            HttpSolrServer server = new HttpSolrServer(this.endpoint);
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(this.query);
            solrQuery.setParam("fl", new String[]{"derivative2,derivative3url"});
            solrQuery.setRows(Integer.valueOf(this.pageSize));
            Iterable items = Lists.newArrayList();
            while (processed < totalMatches) {
                solrQuery.setStart(Integer.valueOf(start));
                log.debug((Object)solrQuery.toString());
                QueryResponse rsp = server.query((SolrParams)solrQuery);
                totalMatches = (int)rsp.getResults().getNumFound();
                ArrayList toDownload = Lists.newArrayList();
                List thumbInfos = rsp.getBeans(ThumbnailInfo.class);
                for (ThumbnailInfo t : thumbInfos) {
                    toDownload.add(this.gson.toJson((Object)t));
                }
                items = Iterables.concat((Iterable)items, (Iterable)toDownload);
                start = processed += thumbInfos.size();
            }
            log.debug((Object)(processed + " records in the result set for thumbnail generation"));
            W3CEndpointReference epr = this.iterableResultSetFactory.createIterableResultSet(items);
            token.getEnv().setAttribute("downloadListEprString", epr.toString());
            token.getEnv().setTransientAttribute("downloadListEpr", (Object)epr);
            super.execute(engine, token);
        }
        catch (SolrServerException e) {
            log.fatal((Object)e.getMessage());
            super.failed(engine, token, (Throwable)e);
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getThumbnailHost() {
        return this.thumbnailHost;
    }

    public void setThumbnailHost(String thumbnailHost) {
        this.thumbnailHost = thumbnailHost;
    }

    public IterableResultSetFactory getIterableResultSetFactory() {
        return this.iterableResultSetFactory;
    }

    public void setIterableResultSetFactory(IterableResultSetFactory iterableResultSetFactory) {
        this.iterableResultSetFactory = iterableResultSetFactory;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

