/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr;

import eu.dnetlib.functionality.index.cql.CqlValueTransformerMap;
import eu.dnetlib.functionality.index.solr.LocalIndexServer;
import eu.dnetlib.functionality.index.solr.cql.SolrTypeBasedCqlValueTransformerMapFactory;
import java.io.IOException;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.schema.IndexSchema;

public class SolrIndex {
    private transient LocalIndexServer server;
    private transient String dsId;
    private transient IndexSchema indexSchema;
    private transient SolrTypeBasedCqlValueTransformerMapFactory tMapFactory;

    public SolrIndex(LocalIndexServer server, String dsId, SolrTypeBasedCqlValueTransformerMapFactory tMapFactory) {
        this.server = server;
        this.indexSchema = server.getSchema();
        this.dsId = dsId;
        this.tMapFactory = tMapFactory;
    }

    public SolrIndex(LocalIndexServer server, SolrTypeBasedCqlValueTransformerMapFactory tMapFactory) {
        this(server, null, tMapFactory);
    }

    public CqlValueTransformerMap getValueTransformerMap() {
        return this.tMapFactory.getIt(this.indexSchema);
    }

    public UpdateResponse add(SolrInputDocument doc) throws SolrServerException, IOException {
        return this.getServer().add(doc);
    }

    public SolrServer getServer() {
        return this.server.getServer();
    }

    public String getDsId() {
        return this.dsId;
    }

    public IndexSchema getIndexSchema() {
        return this.indexSchema;
    }
}

