/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr;

import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.tools.blackboard.AbstractBlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import eu.dnetlib.functionality.index.solr.Action;
import eu.dnetlib.functionality.index.solr.SolrIndexServiceImpl;
import eu.dnetlib.functionality.index.solr.actors.BlackboardActorCallback;
import eu.dnetlib.functionality.index.solr.actors.ResultsetKeepAliveCallback;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.springframework.beans.factory.annotation.Required;

public class SolrIndexNotificationHandler
extends AbstractBlackboardNotificationHandler<BlackboardServerHandler>
implements NotificationHandler {
    private static final Log log = LogFactory.getLog(SolrIndexNotificationHandler.class);
    private SolrIndexServiceImpl indexService;
    private transient JobDetail rsKeepaliveJob;
    private Scheduler jobScheduler;
    private static final long REPEAT_DELAY = 20000L;

    protected void processJob(BlackboardJob job) {
        log.info((Object)("processing solr index job: " + job.getAction()));
        Action action = Action.valueOf(job.getAction());
        try {
            switch (action) {
                case CREATE: {
                    this.performCreateIndex(job);
                    break;
                }
                case FEED: {
                    this.performFeedIndex(job);
                    break;
                }
                case DELETE: {
                    this.performDelete(job);
                    break;
                }
                case TRANSFORM: {
                    this.performTransform(job);
                    break;
                }
                case IDENTIFY: {
                    job.getParameters().put("service_id", this.indexService.identify());
                    break;
                }
                default: {
                    job.setError("unsupported Action: " + action.name());
                    log.warn((Object)("unsupported message action: " + action.name()));
                    throw new IllegalArgumentException("unsupported message action: " + action.name());
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)(job.getAction() + " job set to FAILED "), e);
            ((BlackboardServerHandler)this.getBlackboardHandler()).failed(job, e);
        }
    }

    private void performTransform(BlackboardJob job) throws ISLookUpException, IOException {
        ((BlackboardServerHandler)this.getBlackboardHandler()).ongoing(job);
        log.info((Object)"TRANSFORM job set to ONGOING");
        this.indexService.mergeIndex(job, this.newBBActorCallback(job));
    }

    private void performCreateIndex(BlackboardJob job) throws IndexServiceException {
        ((BlackboardServerHandler)this.getBlackboardHandler()).ongoing(job);
        log.info((Object)"CREATE job set to ONGOING");
        String profileId = this.indexService.createIndex(job, this.newBBActorCallback(job));
        job.getParameters().put("id", profileId);
    }

    private void performDelete(BlackboardJob job) throws IndexServiceException {
        ((BlackboardServerHandler)this.getBlackboardHandler()).ongoing(job);
        log.info((Object)"DELETE job set to ONGOING");
        this.indexService.deleteIndex(job, this.newBBActorCallback(job));
    }

    private void performFeedIndex(BlackboardJob job) throws IndexServiceException, SchedulerException {
        ((BlackboardServerHandler)this.getBlackboardHandler()).ongoing(job);
        log.info((Object)"FEED job set to ONGOING");
        JobDetail tmp = this.jobScheduler.getJobDetail("resultsetKeepaliveJob", "keepalive");
        if (tmp == null) {
            log.fatal((Object)"re-registering job detail");
            this.jobScheduler.addJob(this.rsKeepaliveJob, true);
        }
        String epr = new String(Base64.decodeBase64((byte[])((String)job.getParameters().get("resultset_epr")).getBytes()));
        String triggerId = UUID.randomUUID().toString();
        log.debug((Object)("\n\n scheduling resultSet keepalive trigger: " + triggerId + "\n\n"));
        this.jobScheduler.scheduleJob((Trigger)this.getResultsetTrigger(epr, triggerId));
        this.indexService.feedIndex(job, this.newRSKeepAliveCallback(triggerId), this.newBBActorCallback(job));
    }

    private BlackboardActorCallback newBBActorCallback(final BlackboardJob job) {
        return new BlackboardActorCallback(){

            @Override
            public void setJobDone() {
                log.info((Object)(job.getAction() + " job set to DONE"));
                ((BlackboardServerHandler)SolrIndexNotificationHandler.this.getBlackboardHandler()).done(job);
            }

            @Override
            public void setJobFailed(Throwable exception) {
                log.error((Object)(job.getAction() + " job set to FAILED "), exception);
                ((BlackboardServerHandler)SolrIndexNotificationHandler.this.getBlackboardHandler()).failed(job, exception);
            }
        };
    }

    private ResultsetKeepAliveCallback newRSKeepAliveCallback(final String triggerId) {
        return new ResultsetKeepAliveCallback(){

            @Override
            public void unschedule() {
                try {
                    log.info((Object)("\n\n unscheduling resultSet keepalive trigger: " + triggerId + "\n\n"));
                    SolrIndexNotificationHandler.this.jobScheduler.unscheduleJob(triggerId, "keepalive");
                }
                catch (SchedulerException e) {
                    log.warn((Object)("cannot unschedule RSKeepAlive triggerId: " + triggerId));
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private SimpleTrigger getResultsetTrigger(String rsEpr, String triggerId) {
        SimpleTrigger trigger = new SimpleTrigger(triggerId, "keepalive", -1, 20000L);
        trigger.getJobDataMap().put("resultset_epr", rsEpr);
        trigger.setJobName("resultsetKeepaliveJob");
        trigger.setJobGroup("keepalive");
        return trigger;
    }

    @Required
    public void setIndexService(SolrIndexServiceImpl indexService) {
        this.indexService = indexService;
    }

    public SolrIndexServiceImpl getIndexService() {
        return this.indexService;
    }

    @Required
    public void setJobScheduler(Scheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    public Scheduler getJobScheduler() {
        return this.jobScheduler;
    }

    @Required
    public void setResultsetKeepaliveJob(JobDetail rsKeepaliveJob) {
        this.rsKeepaliveJob = rsKeepaliveJob;
    }

    public JobDetail getResultsetKeepaliveJob() {
        return this.rsKeepaliveJob;
    }
}

