/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.common.ws.dataprov.ResultsResponse;
import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.functionality.index.cql.CqlTranslator;
import eu.dnetlib.functionality.index.solr.IndexDocumentUpdater;
import eu.dnetlib.functionality.index.solr.SolrIndex;
import eu.dnetlib.functionality.index.solr.feed.DocumentFeeder;
import eu.dnetlib.functionality.index.solr.feed.DocumentMapperFactory;
import eu.dnetlib.functionality.index.solr.feed.FeedMode;
import eu.dnetlib.functionality.index.solr.feed.FeedResult;
import eu.dnetlib.functionality.index.solr.feed.IndexDocument;
import eu.dnetlib.functionality.index.solr.query.IndexQuery;
import eu.dnetlib.functionality.index.solr.query.IndexQueryFactory;
import eu.dnetlib.functionality.index.solr.query.QueryLanguage;
import eu.dnetlib.functionality.index.solr.query.QueryResponseFactory;
import eu.dnetlib.functionality.index.solr.query.QueryResponseParser;
import eu.dnetlib.functionality.index.solr.suggest.Hint;
import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.functionality.index.solr.utils.ServiceTools;
import eu.dnetlib.functionality.index.solr.utils.Weights;
import eu.dnetlib.miscutils.collections.Pair;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.StringUtils;
import org.z3950.zing.cql.CQLParseException;

public class SolrIndexServer {
    private static final Log log = LogFactory.getLog(SolrIndexServer.class);
    @Resource
    private transient IndexQueryFactory indexQueryFactory;
    @Resource
    private transient DocumentMapperFactory docMapperFactory;
    @Resource
    private transient QueryResponseFactory queryRespFactory;
    @Resource
    private transient IndexMap indexMap;
    @Resource
    private transient Weights weights;
    @Resource
    private transient ServiceTools serviceTools;
    @Resource
    private transient CqlTranslator cqlTranslator;
    private boolean registerOnFeed;
    private final transient ExecutorService threadPool = Executors.newCachedThreadPool();

    public void init() throws IndexServiceException {
        log.info((Object)"Initializing SolrIndexServer, trying to resume existing indexes");
        List<MetadataReference> indexNames = this.indexMap.getExistingIndexNames();
        for (MetadataReference mdRef : indexNames) {
            List<String> dsId = this.serviceTools.getIndexDsIdsList(mdRef);
            if (dsId != null) {
                this.weights.initialize();
                this.indexMap.register(this.parseFields(this.serviceTools.getIndexFields(mdRef)), mdRef, dsId);
                log.info((Object)("loaded " + this.indexMap.getDsId(mdRef).size() + " dataStructure references for index " + mdRef.toString()));
                continue;
            }
            log.warn((Object)("couldn't find any referenced dataStructure lo load for index: " + mdRef.toString()));
        }
        log.info((Object)("resume report: " + indexNames.size() + " indexes resumed: " + indexNames.toString()));
    }

    private Document parseFields(String fields) throws IndexServiceException {
        try {
            return new SAXReader().read((Reader)new StringReader(fields));
        }
        catch (DocumentException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    public void create(String dsId, MetadataReference mdRef, String fields) throws IndexServiceException {
        log.info((Object)("registering DSId: " + dsId));
        this.indexMap.register(this.parseFields(fields), mdRef, Lists.newArrayList((Object[])new String[]{dsId}));
    }

    public int updateDocuments(String query, MetadataReference mdRef, Map<String, String> fieldXPath, String regex, String replace) throws IndexServiceException {
        ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(100);
        Object sentinel = new Object();
        SolrIndex index = this.indexMap.getIndexByMetadata(mdRef);
        IndexQuery indexQuery = this.indexQueryFactory.getBaseQuery(query, mdRef, "all");
        QueryResponse response = this.performQuery(indexQuery, mdRef);
        Future<Integer> nUpdates = this.threadPool.submit(new IndexDocumentUpdater(queue, sentinel, fieldXPath, index, regex, replace));
        try {
            for (SolrDocument document : response.getResults()) {
                queue.put(document);
            }
            queue.put(sentinel);
            return nUpdates.get();
        }
        catch (InterruptedException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    public void feed(String dsId, String version, FeedMode feedMode, IterableResultSetClient documentIterator) throws IndexServiceException {
        Function<String, IndexDocument> inputDocumentFunction;
        if (!this.indexMap.isRegistered(dsId) && this.isRegisterOnFeed()) {
            MetadataReference mdRef = this.serviceTools.getMetadataRef(dsId);
            this.create(dsId, mdRef, this.serviceTools.getIndexFields(mdRef));
        }
        SolrIndex index = this.indexMap.getIndexByDs(dsId);
        switch (feedMode) {
            case UPDATE: {
                inputDocumentFunction = this.docMapperFactory.getUpdateMapper(index);
                break;
            }
            default: {
                inputDocumentFunction = this.docMapperFactory.getMetatadaMapper(index, version);
            }
        }
        try {
            FeedResult res = this.threadPool.submit(new DocumentFeeder(index, Iterables.transform((Iterable)documentIterator, inputDocumentFunction))).get();
            this.cleanMarkedDocuments(dsId);
            if (feedMode.equals((Object)FeedMode.REFRESH)) {
                this.deleteByVersion(dsId, version);
            }
            index.getServer().commit();
            log.info((Object)("FeedResult: " + res.setTimeElapsed(System.currentTimeMillis())));
        }
        catch (InterruptedException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (SolrServerException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (IOException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    public long deleteByQuery(String query, String dsId, boolean ignoreDsId) throws IndexServiceException {
        String cqlQuery = ignoreDsId ? query : query + " and " + IndexMap.DS_ID + " exact " + dsId;
        try {
            String luceneQuery = this.cqlTranslator.toLucene(cqlQuery);
            MetadataReference mdRef = this.indexMap.getMdRefById(dsId);
            log.info((Object)("DELETE BY QUERY: " + luceneQuery + " on '" + mdRef.toString() + "' physical index"));
            return this.indexMap.getIndexByDs(dsId).getServer().deleteByQuery(luceneQuery).getElapsedTime();
        }
        catch (CQLParseException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (IOException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (SolrServerException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    public long deleteByVersion(String dsId, String mdFormatVersion) throws IndexServiceException {
        String query = IndexMap.DS_VERSION + " < \"" + (String)this.docMapperFactory.getDateMapper().apply((Object)mdFormatVersion) + "\"";
        return this.deleteByQuery(query, dsId, false);
    }

    public long cleanMarkedDocuments(String dsId) throws IndexServiceException {
        String query = IndexMap.DELETE_DOCUMENT + " all true ";
        return this.deleteByQuery(query, dsId, false);
    }

    public ResultsResponse getNumberOfRecords(String dsId) throws IndexServiceException {
        MetadataReference mdRef = this.indexMap.dsMetadataReference(dsId);
        IndexQuery query = this.indexQueryFactory.getIndexQuery(QueryLanguage.SOLR, IndexMap.queryAll, mdRef, dsId);
        QueryResponseParser lookupRes = this.lookup(query, mdRef);
        return this.newResultsResponse(lookupRes.getStatus(), lookupRes.getNumFound());
    }

    public long commit(String dsId) throws IndexServiceException {
        try {
            return this.indexMap.getIndexByDs(dsId).getServer().commit().getElapsedTime();
        }
        catch (SolrServerException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (IOException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    public long optimize(String dsId) throws IndexServiceException {
        try {
            return this.indexMap.getIndexByDs(dsId).getServer().optimize().getElapsedTime();
        }
        catch (SolrServerException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (IOException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    public String[] getIndexList() {
        return this.indexMap.getDsIdArray();
    }

    public String getIndexListCSV() {
        return StringUtils.arrayToCommaDelimitedString((Object[])this.getIndexList());
    }

    public Pair<String, Hint> suggest(QueryLanguage lang, String term, MetadataReference mdRef, String dsId) throws IndexServiceException {
        IndexQuery query = this.indexQueryFactory.getSuggestionQuery(lang, term, mdRef, dsId);
        log.info((Object)("running suggestion query: " + query.toString()));
        QueryResponse rsp = this.performQuery(query, mdRef);
        SpellCheckResponse splCk = rsp.getSpellCheckResponse();
        Hint hint = new Hint();
        String newQuery = "";
        if (splCk != null) {
            for (SpellCheckResponse.Suggestion s : splCk.getSuggestions()) {
                String alternateTerm = (String)Iterables.getFirst((Iterable)s.getAlternatives(), (Object)s.getToken());
                if (alternateTerm.equalsIgnoreCase(s.getToken())) continue;
                hint.addHint(s.getToken(), alternateTerm);
            }
            switch (lang) {
                case CQL: {
                    newQuery = query.applyHints(splCk.getSuggestionMap()).getQueryRoot().toCQL();
                    break;
                }
                case SOLR: {
                    newQuery = splCk.getCollatedResult();
                    break;
                }
                default: {
                    throw new IndexServiceException("Unknow query language: " + (Object)((Object)lang));
                }
            }
            query = this.indexQueryFactory.getIndexQuery(lang, newQuery, mdRef, dsId);
            query.setRows(0).set("spellcheck.build", false);
            long spellcheck = this.performQuery(query, mdRef).getResults().getNumFound();
            long numFound = rsp.getResults().getNumFound();
            log.info((Object)("numFound: " + numFound + ", spellcheck: " + spellcheck));
            hint.setAutofollow(spellcheck > numFound);
        }
        return new Pair((Object)newQuery, (Object)hint);
    }

    public QueryResponse performQuery(IndexQuery query, MetadataReference mdRef) throws IndexServiceException {
        try {
            return this.indexMap.getIndexByMetadata(mdRef).getServer().query((SolrParams)query);
        }
        catch (SolrServerException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    private QueryResponseParser getResponseParser(QueryResponse rsp, MetadataReference mdRef) {
        return this.queryRespFactory.getQueryResponseParser(rsp, mdRef);
    }

    public QueryResponseParser lookup(IndexQuery query, MetadataReference mdRef) throws IndexServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("performing query: " + query.toString()));
        }
        return this.getResponseParser(this.performQuery(query, mdRef), mdRef);
    }

    private ResultsResponse newResultsResponse(String status, long total) {
        ResultsResponse res = new ResultsResponse();
        res.setStatus(status);
        res.setTotal((int)total);
        return res;
    }

    public IndexMap getIndexMap() {
        return this.indexMap;
    }

    public boolean isRegisterOnFeed() {
        return this.registerOnFeed;
    }

    @Required
    public void setRegisterOnFeed(boolean registerOnFeed) {
        this.registerOnFeed = registerOnFeed;
    }
}

