/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.direct;

import eu.dnetlib.functionality.index.solr.direct.DirectIndexService;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.dom4j.DocumentException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.z3950.zing.cql.CQLParseException;

@Controller
public class DirectIndexController {
    @Resource
    private DirectIndexService directService;

    @RequestMapping(value={"/directindex.do/**"})
    void dispatcher(OutputStream out, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="id", required=false) String id, @RequestParam(value="index", required=false) String index, @RequestParam(value="query", required=false) String query, @RequestParam(value="mdformat", required=false) String mdformat, @RequestParam(value="layout", required=false) String layout, @RequestParam(value="rsId", required=false) String rsId, @RequestParam(value="fromPosition", required=false) String fromPosition, @RequestParam(value="toPosition", required=false) String toPosition, @RequestParam(value="requestMode", required=false) String requestMode) throws IOException, SolrServerException, CQLParseException, DocumentException {
        String path = request.getPathInfo().replaceAll("/directindex.do/", "");
        String method = path.substring(path.indexOf(47) + 1);
        response.setContentType("text/xml; charset=utf-8");
        if ("indexLookup".equals(method)) {
            this.indexLookup(out, id, query, mdformat, layout);
        } else if ("getNumberOfElements".equals(method)) {
            this.getNumberOfElements(out, rsId);
        } else if ("getResult".equals(method)) {
            this.getResults(out, rsId, fromPosition, toPosition);
        } else if ("getBrowsingStatistics".equals(method)) {
            this.getBrowsingStatistics(out, index, query, mdformat, layout);
        }
    }

    private void getResults(OutputStream out, String rsId, String fromPosition, String toPosition) throws NumberFormatException, IOException {
        out.write(this.directService.getResult(rsId, Integer.parseInt(fromPosition), Integer.parseInt(toPosition)).getBytes());
    }

    private void getNumberOfElements(OutputStream out, String rsId) throws IOException {
        out.write(this.directService.getNumberOfElements(rsId).getBytes());
    }

    private void indexLookup(OutputStream out, String id, String query, String mdformat, String layout) throws IOException {
        out.write(this.directService.indexLookup(id, query, mdformat, layout).getBytes());
    }

    private void getBrowsingStatistics(OutputStream out, String id, String query, String mdformat, String layout) throws IOException {
        out.write(this.directService.getBrowsingStatistics(query, id, mdformat, layout).getBytes());
    }
}

