/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.direct;

import eu.dnetlib.enabling.resultset.LocalResultSetImpl;
import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.enabling.resultset.ResultSetRegistry;
import eu.dnetlib.functionality.index.solr.query.QueryLanguage;
import eu.dnetlib.functionality.index.solr.resultset.factory.BrowsingResultSetListenerFactory;
import eu.dnetlib.functionality.index.solr.resultset.factory.IndexResultSetListenerFactory;
import eu.dnetlib.functionality.index.solr.resultset.factory.LookupResultSetListenerFactory;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.functionality.index.solr.utils.MetadataReferenceFactory;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.string.EscapeXml;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.antlr.stringtemplate.StringTemplate;

public class DirectIndexService {
    private static final int GETRESULT_LIMIT = 100;
    @Resource(name="directIndexEprTemplate")
    private StringTemplate eprTemplate;
    @Resource(name="directNumberOfResultsTemplate")
    private StringTemplate numberOfResultsTemplate;
    @Resource(name="directResultsTemplate")
    private StringTemplate resultsTemplate;
    @Resource(name="directInlineResultsTemplate")
    private StringTemplate inlineResultsTemplate;
    @Resource(name="directErrorTemplate")
    private StringTemplate errorTemplate;
    @Resource(name="resultSetRegistry")
    private ResultSetRegistry resultsetRegistry;
    @Resource
    private MetadataReferenceFactory mdFactory;
    @Resource
    private LookupResultSetListenerFactory lookupListenerFactory;
    @Resource
    private BrowsingResultSetListenerFactory browsingListenerFactory;
    @Resource(name="directIndexBaseUrl")
    private String baseUrl;
    private ThreadLocal<StringTemplate> localEprTemplate = new ThreadLocal<StringTemplate>(){

        @Override
        protected StringTemplate initialValue() {
            return new StringTemplate(DirectIndexService.this.eprTemplate.getTemplate());
        }
    };
    private ThreadLocal<StringTemplate> localInlineResultsTemplate = new ThreadLocal<StringTemplate>(){

        @Override
        protected StringTemplate initialValue() {
            return new StringTemplate(DirectIndexService.this.inlineResultsTemplate.getTemplate());
        }
    };

    @PostConstruct
    public void init() {
        this.baseUrl = this.baseUrl.trim();
    }

    public String renderError(String message) {
        StringTemplate template = new StringTemplate(this.errorTemplate.getTemplate());
        template.setAttribute("message", (Object)message);
        return template.toString();
    }

    public String indexLookup(String id, String query, String mdformat, String layout) {
        return this.performLookup(this.lookupListenerFactory, id, query, mdformat, layout);
    }

    public String getBrowsingStatistics(String query, String id, String mdformat, String layout) {
        return this.performLookup(this.browsingListenerFactory, id, query, mdformat, layout);
    }

    private String performLookup(IndexResultSetListenerFactory listenerFactory, String id, String query, String mdformat, String layout) {
        try {
            StringTemplate template = this.localEprTemplate.get();
            MetadataReference mdRef = this.mdFactory.getMetadata(mdformat, layout);
            ResultSetListener listener = listenerFactory.getListener(QueryLanguage.CQL, query, mdRef, id);
            LocalResultSetImpl resultSet = new LocalResultSetImpl(listener);
            this.resultsetRegistry.addResultSet((ResultSet)resultSet);
            template.removeAttribute("baseUrl");
            template.setAttribute("baseUrl", (Object)this.baseUrl);
            template.removeAttribute("rsId");
            template.setAttribute("rsId", (Object)resultSet.getIdentifier());
            return template.toString();
        }
        catch (Throwable e) {
            return this.renderError(e.getMessage());
        }
    }

    public String inlineIndexLookup(String id, String query, String mdformat, String layout, int fromPosition, int toPosition) {
        try {
            MetadataReference mdRef = this.mdFactory.getMetadata(mdformat, layout);
            ResultSetListener listener = this.lookupListenerFactory.getListener(QueryLanguage.CQL, query, mdRef, id);
            StringTemplate template = this.localInlineResultsTemplate.get();
            template.removeAttribute("results");
            template.setAttribute("results", (Object)MappedCollection.listMap((Iterable)listener.getResult(fromPosition, toPosition), (UnaryFunction)new EscapeXml()));
            return template.toString();
        }
        catch (Throwable e) {
            return this.renderError(e.getMessage());
        }
    }

    public String getNumberOfElements(String rsId) {
        ResultSet rs = this.resultsetRegistry.getResultSetById(rsId);
        try {
            if (rs == null) {
                return this.renderError("resultset with id '" + rsId + "' doesn't exist");
            }
            StringTemplate template = new StringTemplate(this.numberOfResultsTemplate.getTemplate());
            template.setAttribute("number", rs.getNumberOfResults());
            return template.toString();
        }
        catch (Throwable e) {
            return this.renderError(e.getMessage());
        }
    }

    public String getResult(String rsId, int fromPosition, int toPosition) {
        try {
            if (fromPosition > 100 || toPosition > 100) {
                throw new IllegalArgumentException("fromPosition, toPosition must be < 100");
            }
            ResultSet rs = this.resultsetRegistry.getResultSetById(rsId);
            if (rs == null) {
                return this.renderError("resultset with id '" + rsId + "' doesn't exist");
            }
            List page = rs.getResults(fromPosition, toPosition);
            StringTemplate template = new StringTemplate(this.resultsTemplate.getTemplate());
            template.setAttribute("results", (Object)MappedCollection.listMap((Iterable)page, (UnaryFunction)new EscapeXml()));
            return template.toString();
        }
        catch (Throwable e) {
            return this.renderError(e.getMessage());
        }
    }
}

