/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.feed;

import eu.dnetlib.functionality.index.solr.SolrIndex;
import eu.dnetlib.functionality.index.solr.feed.FeedResult;
import eu.dnetlib.functionality.index.solr.feed.IndexDocument;
import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DocumentFeeder
implements Callable<FeedResult> {
    private static final Log log = LogFactory.getLog(DocumentFeeder.class);
    private SolrIndex index;
    private Iterable<IndexDocument> records;

    public DocumentFeeder(SolrIndex index, Iterable<IndexDocument> records) {
        this.index = index;
        this.records = records;
    }

    @Override
    public FeedResult call() throws Exception {
        FeedResult res = new FeedResult(System.currentTimeMillis());
        block5: for (IndexDocument doc : this.records) {
            switch (doc.getStatus()) {
                case OK: {
                    this.index.add(doc);
                    res.add();
                    continue block5;
                }
                case MARKED: {
                    res.mark();
                    log.debug((Object)("skipping record: " + doc.getFieldValue(IndexMap.INDEX_RECORD_ID)));
                    continue block5;
                }
                case ERROR: {
                    res.skip();
                    continue block5;
                }
            }
            throw new IllegalStateException("unknow document status");
        }
        return res;
    }
}

