/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.feed;

import eu.dnetlib.functionality.index.solr.SolrIndex;
import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import java.util.Map;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.schema.FieldType;

public class IndexDocument
extends SolrInputDocument {
    private static final long serialVersionUID = -3138617803733330878L;
    private STATUS status;
    private SolrIndex index;
    private Throwable error = null;

    public IndexDocument(SolrIndex index) {
        this.index = index;
        this.addField(IndexMap.DS_ID, index.getDsId());
    }

    public void addField(String name, Object value) {
        super.addField(name, this.hackField(name, value));
    }

    public void setField(String name, Object value) {
        super.setField(name, this.hackField(name, value));
    }

    private Object hackField(String name, Object value) {
        FieldType type = this.index.getIndexSchema().getField(name).getType();
        if (type.getTypeName().equals("date")) {
            value = value + "T00:00:00Z";
        }
        return value;
    }

    public IndexDocument setContent(SolrDocument solrDocument) {
        for (Map.Entry field : solrDocument.entrySet()) {
            super.setField((String)field.getKey(), field.getValue());
        }
        return this;
    }

    public IndexDocument setMarked() {
        super.addField(IndexMap.DELETE_DOCUMENT, (Object)true);
        return this.setStatus(STATUS.MARKED);
    }

    public IndexDocument setError(Throwable error) {
        this.error = error;
        return this.setStatus(STATUS.ERROR);
    }

    public IndexDocument setOK() {
        return this.setStatus(STATUS.OK);
    }

    public Throwable getError() {
        return this.error;
    }

    public STATUS getStatus() {
        return this.status;
    }

    private IndexDocument setStatus(STATUS status) {
        this.status = status;
        return this;
    }

    public SolrIndex getIndex() {
        return this.index;
    }

    public void setIndex(SolrIndex index) {
        this.index = index;
    }

    public static enum STATUS {
        MARKED,
        ERROR,
        OK;

    }
}

