/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.query;

import com.google.common.collect.Maps;
import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.functionality.index.cql.CqlTranslator;
import eu.dnetlib.functionality.index.cql.TranslatedQuery;
import eu.dnetlib.functionality.index.solr.query.IndexQuery;
import eu.dnetlib.functionality.index.solr.query.Pruner;
import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.functionality.index.solr.utils.Weights;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Required;
import org.z3950.zing.cql.CQLParseException;

public class BaseQueryFactory {
    private Pruner pruner;
    private Pruner cqlPruner;
    private IndexMap indexMap;
    private CqlTranslator translator;
    @Resource
    private Weights weights;
    private Map<String, List<String>> defaultQueryParams;

    public IndexQuery newInstance(String query, MetadataReference mdRef) throws IndexServiceException {
        try {
            Pruner.Result cqlRes = this.getCqlPruner().prune(this.getCqlPruner().parse(query));
            Pruner.Result res = this.getPruner().prune(cqlRes.getNode());
            TranslatedQuery solrQuery = this.getTranslator().getTranslatedQuery(res.getNode(), this.getIndexMap().getIndexByMetadata(mdRef).getValueTransformerMap(), this.overrideCqlParams(cqlRes.getOptionMap()), this.indexMap.browsingAliases(mdRef), (Map)this.getWeights().get(mdRef));
            return new IndexQuery(solrQuery, res.getNode(), res.getOptionMap());
        }
        catch (CQLParseException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (IOException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    private Map<String, List<String>> overrideCqlParams(Map<String, List<String>> override) {
        HashMap cqlParams = Maps.newHashMap();
        cqlParams.putAll(this.getDefaultQueryParams());
        cqlParams.putAll(override);
        return cqlParams;
    }

    public Weights getWeights() {
        return this.weights;
    }

    public Pruner getPruner() {
        return this.pruner;
    }

    @Required
    public void setPruner(Pruner pruner) {
        this.pruner = pruner;
    }

    public Pruner getCqlPruner() {
        return this.cqlPruner;
    }

    @Required
    public void setCqlPruner(Pruner cqlPruner) {
        this.cqlPruner = cqlPruner;
    }

    public IndexMap getIndexMap() {
        return this.indexMap;
    }

    @Required
    public void setIndexMap(IndexMap indexMap) {
        this.indexMap = indexMap;
    }

    public Map<String, List<String>> getDefaultQueryParams() {
        return this.defaultQueryParams;
    }

    public void setDefaultQueryParams(Map<String, List<String>> defaultQueryParams) {
        this.defaultQueryParams = defaultQueryParams;
    }

    public CqlTranslator getTranslator() {
        return this.translator;
    }

    public void setTranslator(CqlTranslator translator) {
        this.translator = translator;
    }
}

