/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.query;

import com.google.common.collect.BiMap;
import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.functionality.index.solr.query.BaseQueryFactory;
import eu.dnetlib.functionality.index.solr.query.IndexQuery;
import eu.dnetlib.functionality.index.solr.query.QueryLanguage;
import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.miscutils.datetime.HumanTime;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.z3950.zing.cql.CQLParseException;

public class IndexQueryFactory {
    private static final Log log = LogFactory.getLog(IndexQueryFactory.class);
    private static String GROUPBY = "&groupby=";
    private static String AND = " and ";
    private static String CLAUSE_PREFIX = "solr.facet.field=";
    private static String BROWSE_PREFIX = "(>solr=NAMESPACE solr.facet=true" + AND;
    private static String GROUP_BY_DELIMITER = ",";
    public static String QUERY_PREFIX = "query=";
    public static String INDEX_DELIMITER = ",";
    private IndexMap indexMap;
    @Resource
    private BaseQueryFactory baseQueryFactory;
    private boolean enableHighlight = true;
    private boolean includeRanking;
    private int maxBrowseResults;

    public IndexQuery getIndexQuery(QueryLanguage lang, String query, MetadataReference mdRef, String ... dsId) throws IndexServiceException {
        return this._getIndexQuery(lang, query, mdRef, dsId);
    }

    private IndexQuery _getIndexQuery(QueryLanguage lang, String query, MetadataReference mdRef, String ... dsId) throws IndexServiceException {
        switch (lang) {
            case CQL: {
                return this.getCqlQuery(query, mdRef, dsId);
            }
            case SOLR: {
                return this.getSolrQuery(query);
            }
        }
        throw new IllegalArgumentException("unknow query language");
    }

    private IndexQuery getSolrQuery(String query) throws IndexServiceException {
        try {
            IndexQuery indexQuery = new IndexQuery(query);
            log.debug((Object)("SOLR indexQuery: \"" + indexQuery.toString() + "\""));
            return indexQuery;
        }
        catch (CQLParseException e) {
            throw new IndexServiceException((Throwable)e);
        }
        catch (IOException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    private IndexQuery getCqlQuery(String query, MetadataReference mdRef, String ... dsId) throws IndexServiceException {
        log.debug((Object)("building CQL IndexQuery from: " + query));
        long startTime = System.currentTimeMillis();
        IndexQuery solrIndexQuery = this.getBaseQuery(query, mdRef, dsId);
        solrIndexQuery.setIncludeScore(this.includeRanking);
        log.debug((Object)("Hightlight enabled: " + (solrIndexQuery.getHighlight() & this.enableHighlight)));
        if (solrIndexQuery.getHighlight() & this.enableHighlight) {
            solrIndexQuery.setHighlightFragsize(0).setHighlightSnippets(1).setHighlightSimplePre("[hl]").setHighlightSimplePost("[/hl]").addHighlightField(IndexMap.RESULT).addField(IndexMap.INDEX_RECORD_ID).set("hl.useFastVectorHighlighter", new String[]{"true"});
        }
        if (solrIndexQuery.getFacetFields() == null) {
            solrIndexQuery.addField(IndexMap.RESULT);
        } else {
            log.debug((Object)("getFacetFields() " + Arrays.asList(solrIndexQuery.getFacetFields())));
            solrIndexQuery.setFacetMinCount(1);
            solrIndexQuery.setRows(0);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(HumanTime.exactly((long)(System.currentTimeMillis() - startTime)) + " to build CQL IndexQuery: " + solrIndexQuery.toString()));
        }
        return solrIndexQuery;
    }

    public IndexQuery getBaseQuery(String query, MetadataReference mdRef, String ... dsId) throws IndexServiceException {
        if (query == null || query.isEmpty()) {
            throw new IllegalArgumentException("query cannot be empty or null");
        }
        if (dsId == null || dsId.length == 0) {
            throw new IllegalArgumentException("at least one indexDataStructure id must be specified");
        }
        String parsedQuery = this.getBrowsingFields(query.replaceAll(QUERY_PREFIX, ""), mdRef);
        log.debug((Object)("parsing with zing: " + parsedQuery));
        IndexQuery indexQuery = this.baseQueryFactory.newInstance(parsedQuery, mdRef);
        if (!this.indexMap.isAll(dsId)) {
            if (!this.indexMap.indexHandles(mdRef, dsId)) {
                throw new IllegalArgumentException("all specified indexDataStructure ids must be handled by " + mdRef.toString());
            }
            indexQuery = this.getDSIds(indexQuery, dsId);
        }
        return indexQuery;
    }

    public IndexQuery getSuggestionQuery(QueryLanguage lang, String query, MetadataReference mdRef, String dsId) throws IndexServiceException {
        IndexQuery indexQuery = this._getIndexQuery(lang, query, mdRef, dsId);
        indexQuery.setRows(0).set("spellcheck.build", true).set("spellcheck.collate", true).set("spellcheck", true);
        return indexQuery;
    }

    private String getBrowsingFields(String query, MetadataReference mdRef) {
        if (query.contains(GROUPBY)) {
            BiMap<String, String> aliases = this.indexMap.browsingAliases(mdRef);
            String cql = query.split(GROUPBY)[0];
            String clauses = query.split(GROUPBY)[1].replaceAll(GROUP_BY_DELIMITER, AND);
            String newclauses = "";
            for (String clause : clauses.split(AND)) {
                String cleanClause = clause.trim().toLowerCase();
                String clauseAlias = aliases.get((Object)cleanClause) == null ? (String)aliases.inverse().get((Object)cleanClause) : (String)aliases.get((Object)cleanClause);
                String fieldName = clauseAlias != null ? clauseAlias : cleanClause;
                clauses = clauses.replaceAll(clause, CLAUSE_PREFIX + fieldName);
                if (!newclauses.isEmpty()) {
                    newclauses = newclauses + AND;
                }
                newclauses = newclauses + CLAUSE_PREFIX + fieldName;
            }
            query = BROWSE_PREFIX + newclauses + ")" + AND + cql;
            log.debug((Object)("low level browse query " + query));
        }
        return query;
    }

    private IndexQuery getDSIds(IndexQuery query, String[] dsId) {
        if (!dsId[0].equalsIgnoreCase(IndexMap.INDEX_DSID_ALL)) {
            for (String id : dsId) {
                query.addFilterQuery(new String[]{IndexMap.DS_ID + ":\"" + id + "\""});
            }
        }
        return query;
    }

    @Required
    public void setIndexMap(IndexMap indexMap) {
        this.indexMap = indexMap;
    }

    public boolean isEnableHighlight() {
        return this.enableHighlight;
    }

    public void setEnableHighlight(boolean enableHighlight) {
        this.enableHighlight = enableHighlight;
    }

    @Required
    public void setIncludeRanking(boolean includeRanking) {
        this.includeRanking = includeRanking;
    }

    public boolean isIncludeRanking() {
        return this.includeRanking;
    }

    @Required
    public void setMaxBrowseResults(int maxBrowseResults) {
        this.maxBrowseResults = maxBrowseResults;
    }

    public int getMaxBrowseResults() {
        return this.maxBrowseResults;
    }
}

