/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.rmi;

import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class IndexFilesController {
    private static final String INDEXFILELIST_DO = "/indexfilelist.do";
    private final String mimeType = "application/octet-stream";
    @Resource
    private IndexMap indexMap;

    @RequestMapping(value={"/indexfilelist.do/**"})
    public void indexFileList(HttpServletRequest request, ServletResponse response, OutputStream output) throws Exception {
        String path = request.getPathInfo().replace(INDEXFILELIST_DO, "");
        if (path.contains("..")) {
            return;
        }
        this.renderStatic(response, output, path);
    }

    protected void renderStatic(ServletResponse response, OutputStream output, String name) throws IOException {
        String indexPath = this.indexMap.getSolrDataDir() + "/" + name;
        File file = new File(indexPath);
        if (!file.canRead()) {
            return;
        }
        this.renderStatic(response, output, FileUtils.openInputStream((File)file));
    }

    protected void renderStatic(ServletResponse response, OutputStream output, InputStream input) throws IOException {
        response.setContentType("application/octet-stream");
        IOUtils.copy((InputStream)input, (OutputStream)output);
    }
}

