/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.utils;

import com.google.common.base.Function;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.functionality.index.solr.LocalIndexServer;
import eu.dnetlib.functionality.index.solr.SolrIndex;
import eu.dnetlib.functionality.index.solr.SolrIndexFactory;
import eu.dnetlib.functionality.index.solr.utils.InitUtils;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.functionality.index.solr.utils.MetadataReferenceFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.core.CoreContainer;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Required;

public class IndexMap {
    private static final Log log = LogFactory.getLog(IndexMap.class);
    public static String INDEX_FIELD_PREFIX = "__";
    public static String INDEX_DSID_ALL = "ALL";
    public static String SCORE_FIELD = "score";
    public static String DS_ID = INDEX_FIELD_PREFIX + "dsid";
    public static String DS_VERSION = INDEX_FIELD_PREFIX + "dsversion";
    public static String RESULT = INDEX_FIELD_PREFIX + "result";
    public static String ALL_FIELDS = INDEX_FIELD_PREFIX + "all";
    public static String DELETE_DOCUMENT = INDEX_FIELD_PREFIX + "deleted";
    public static String INDEX_RECORD_ID = INDEX_FIELD_PREFIX + "indexrecordidentifier";
    public static String FULLTEXT_ID = INDEX_FIELD_PREFIX + "fulltext";
    public static String INDEXNAME_PARAM = INDEX_FIELD_PREFIX + "indexName";
    public static String queryAll = "*:*";
    private static String FIELD_NAME = "name";
    private static String FIELD_BROWSING_ALIAS_FOR = "browsingAliasFor";
    private static String XPATH_BROWSING_ALIAS_FOR = "//FIELD[@" + FIELD_BROWSING_ALIAS_FOR + "]";
    private String solrDataDir;
    private InitUtils initUtils;
    private MetadataReferenceFactory mdFactory;
    private SolrIndexFactory solrIndexFactory;
    protected Map<String, MetadataReference> dsToIndex = new ConcurrentHashMap<String, MetadataReference>();
    protected Map<MetadataReference, LocalIndexServer> serverMap = new ConcurrentHashMap<MetadataReference, LocalIndexServer>();
    private Map<MetadataReference, BiMap<String, String>> browseAliases = new ConcurrentHashMap<MetadataReference, BiMap<String, String>>();

    public void register(Document fields, MetadataReference mdRef, List<String> dsIds) throws IndexServiceException {
        if (fields != null && !this.isRegistered(mdRef)) {
            log.info((Object)("indexSet was empty for index " + mdRef.toString()));
            this.initUtils.buildConfiguration(mdRef.toString(), fields);
            this.browseAliases.put(mdRef, this.extractBrowsingAliases(fields));
        }
        this.add(mdRef, dsIds);
    }

    public boolean isRegistered(String dsId) {
        return this.dsToIndex.containsKey(dsId);
    }

    public boolean isRegistered(MetadataReference mdRef) {
        return this.serverMap.containsKey(mdRef);
    }

    public SolrIndex getIndexByMetadata(MetadataReference mdRef) {
        return this.solrIndexFactory.getSolrIndex(this.getLocalServer(mdRef));
    }

    public SolrIndex getIndexByDs(String dsId) {
        return this.getIndexByMetadata(this.getMdRefById(dsId));
    }

    private LocalIndexServer getLocalServer(MetadataReference mdRef) {
        if (!this.isRegistered(mdRef)) {
            throw new IllegalStateException("cannot find index server: " + mdRef.toString());
        }
        return this.serverMap.get(mdRef);
    }

    public CoreContainer getCoreContainer(MetadataReference mdRef) {
        return this.getLocalServer(mdRef).getContainer();
    }

    public void updateIndexSchema(Document fields, MetadataReference mdRef) throws IndexServiceException {
        log.info((Object)("updating schema for index: " + mdRef.toString()));
        this.initUtils.updateSchema(mdRef.toString(), fields);
        this.browseAliases.put(mdRef, this.extractBrowsingAliases(fields));
        this.getLocalServer(mdRef).setSchema(this.initUtils.getIndexSchema(mdRef.toString()));
        this.getLocalServer(mdRef).restartCore();
    }

    public void mergeIndexes(MetadataReference mdRef, List<String> paths) throws IOException {
        this.getLocalServer(mdRef).mergeIndexes(paths);
    }

    public boolean indexHandles(MetadataReference mdRef, String ... dsId) {
        return this.getDsId(mdRef).containsAll(Lists.newArrayList((Object[])dsId));
    }

    public boolean isAll(String ... dsId) {
        return dsId.length == 1 && dsId[0].equalsIgnoreCase(INDEX_DSID_ALL);
    }

    public MetadataReference dsMetadataReference(String dsId) {
        return this.mdFactory.getMetadata(this.dsFormat(dsId), this.dsLayout(dsId), this.dsInterpretation(dsId));
    }

    public MetadataReference getMdRefById(String dsId) {
        return this.dsToIndex.get(dsId);
    }

    public Set<String> getDsId(MetadataReference mdRef) {
        return this.getLocalServer(mdRef).getDsIds();
    }

    public String[] getDsIdArray() {
        Iterable dsIds = Lists.newArrayList();
        for (MetadataReference mdRef : this.serverMap.keySet()) {
            dsIds = Iterables.concat((Iterable)dsIds, this.getLocalServer(mdRef).getDsIds());
        }
        Class<String> typeDef = String.class;
        return (String[])Iterables.toArray((Iterable)dsIds, typeDef);
    }

    public int getIndexSize() {
        return this.serverMap.size();
    }

    public List<MetadataReference> getIndexNames() {
        return Lists.newArrayList(this.serverMap.keySet());
    }

    public List<String> listIndexFiles(MetadataReference mdRef) {
        return this.initUtils.listIndexFiles(mdRef.toString());
    }

    public List<MetadataReference> getExistingIndexNames() {
        log.info((Object)"looking for previously created indexes...");
        return Lists.newArrayList((Iterable)Iterables.transform(this.initUtils.getExistingIndexNames(), (Function)new Function<String, MetadataReference>(){

            public MetadataReference apply(String name) {
                return IndexMap.this.mdFactory.decodeMetadata(name);
            }
        }));
    }

    public BiMap<String, String> browsingAliases(MetadataReference mdRef) {
        return this.browseAliases.get(mdRef);
    }

    private BiMap<String, String> extractBrowsingAliases(Document fields) {
        HashBiMap aliases = HashBiMap.create();
        List fieldList = fields.getRootElement().selectNodes(XPATH_BROWSING_ALIAS_FOR);
        for (Element e : fieldList) {
            String name = e.attribute(FIELD_BROWSING_ALIAS_FOR).getValue().toLowerCase();
            String alias = e.attribute(FIELD_NAME).getValue().toLowerCase();
            aliases.put((Object)name, (Object)alias);
        }
        if (aliases.isEmpty()) {
            log.warn((Object)"couldn'f find alias fields for browsing");
        }
        return aliases;
    }

    private void add(MetadataReference mdRef, List<String> dsIds) throws IndexServiceException {
        if (this.isHandled(dsIds)) {
            throw new IllegalStateException("dsId: " + dsIds.toString() + " already handled by index: " + mdRef.toString());
        }
        if (!this.isRegistered(mdRef)) {
            this.serverMap.put(mdRef, new LocalIndexServer(mdRef, dsIds, this.solrDataDir, this.initUtils.getIndexSchema(mdRef.toString())));
        } else {
            this.getLocalServer(mdRef).getDsIds().addAll(dsIds);
        }
        for (String id : dsIds) {
            this.dsToIndex.put(id, mdRef);
        }
    }

    private boolean isHandled(List<String> dsIds) {
        return !dsIds.isEmpty() && this.dsToIndex.keySet().containsAll(dsIds);
    }

    private String dsFormat(String dsId) {
        return this.dsToIndex.get(dsId).getFormat();
    }

    private String dsLayout(String dsId) {
        return this.dsToIndex.get(dsId).getLayout();
    }

    private String dsInterpretation(String dsId) {
        return this.dsToIndex.get(dsId).getInterpretation();
    }

    @Required
    public void setSolrDataDir(String solrDataDir) {
        this.solrDataDir = solrDataDir;
    }

    public String getSolrDataDir() {
        return this.solrDataDir;
    }

    @Required
    public void setInitUtils(InitUtils initUtils) {
        this.initUtils = initUtils;
    }

    public InitUtils getInitUtils() {
        return this.initUtils;
    }

    @Required
    public void setMdFactory(MetadataReferenceFactory mdFactory) {
        this.mdFactory = mdFactory;
    }

    public MetadataReferenceFactory getMdFactory() {
        return this.mdFactory;
    }

    @Required
    public void setSolrIndexFactory(SolrIndexFactory solrIndexFactory) {
        this.solrIndexFactory = solrIndexFactory;
    }

    public SolrIndexFactory getSolrIndexFactory() {
        return this.solrIndexFactory;
    }
}

