/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.utils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.inject.internal.Lists;
import com.mycila.xmltool.CallBack;
import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLTag;
import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.functionality.index.solr.utils.MetadataReferenceFactory;
import eu.dnetlib.functionality.index.solr.utils.ServiceTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public class MDFormatReader {
    @Resource
    private ServiceTools serviceTools;
    @Resource
    private MetadataReferenceFactory mdFactory;

    public List<MetadataReference> listMDRefs() throws IndexServiceException {
        ArrayList mdRefs = Lists.newArrayList();
        for (String m : this.serviceTools.listMDRefs()) {
            mdRefs.add(this.mdFactory.decodeMetadata(m));
        }
        return mdRefs;
    }

    public Map<String, String> getAttributeMap(MetadataReference mdRef, String attribute) throws IndexServiceException {
        return this.getAttributeTable(mdRef, attribute).column((Object)attribute);
    }

    public Table<String, String, String> getAttributeTable(MetadataReference mdRef, final String ... attributeList) throws IndexServiceException {
        HashBasedTable t = HashBasedTable.create();
        XMLDoc.from((String)this.serviceTools.getIndexFields(mdRef), (boolean)false).forEach("//FIELD", new CallBack((Table)t){
            final /* synthetic */ Table val$t;
            {
                this.val$t = table;
            }

            public void execute(XMLTag field) {
                for (String attribute : attributeList) {
                    String value = null;
                    if ("xpath".equals(attribute)) {
                        if (!field.hasAttribute("xpath") && !field.hasAttribute("value")) {
                            return;
                        }
                        String string = value = field.hasAttribute("xpath") ? field.getAttribute("xpath") : field.getAttribute("value");
                    }
                    if ("weight".equals(attribute)) {
                        if (!field.hasAttribute(attribute)) {
                            return;
                        }
                        String string = value = field.hasAttribute(attribute) ? field.getAttribute(attribute) : "";
                    }
                    if (value == null) {
                        value = field.getAttribute(attribute);
                    }
                    this.val$t.put((Object)field.getAttribute("name").toLowerCase(), (Object)attribute, (Object)value);
                }
            }
        });
        return t;
    }
}

