/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.utils;

import eu.dnetlib.enabling.tools.AbstractSchedulable;
import eu.dnetlib.functionality.index.solr.utils.IndexMap;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.File;
import org.apache.commons.io.FileSystemUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class OptimizationJob
extends AbstractSchedulable {
    private double spaceMargin;
    private static final Log log = LogFactory.getLog(OptimizationJob.class);
    private IndexMap indexMap;

    protected void doExecute() {
        log.info((Object)("Started OPTIMIZATION @" + DateUtils.now_ISO8601()));
        try {
            long freeSpace = FileSystemUtils.freeSpaceKb((String)this.indexMap.getSolrDataDir());
            for (MetadataReference mdRef : this.getIndexMap().getIndexNames()) {
                long usedSpace = FileUtils.sizeOfDirectory((File)new File(this.indexMap.getSolrDataDir() + "/" + mdRef.toString())) / 1024L;
                double neededSpace = (double)(2L * usedSpace) + (double)usedSpace * this.getSpaceMargin();
                if (neededSpace < (double)freeSpace) {
                    long optimizeTime = this.indexMap.getIndexByMetadata(mdRef).getServer().optimize().getElapsedTime() / 1000L;
                    log.info((Object)("Finished  OPTIMIZATION index: " + mdRef.toString() + " time: " + optimizeTime + " sec"));
                    continue;
                }
                log.info((Object)("prevented optimization for index " + mdRef.toString() + ", it needs " + neededSpace + "Kb of free space"));
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public IndexMap getIndexMap() {
        return this.indexMap;
    }

    @Required
    public void setIndexMap(IndexMap indexMap) {
        this.indexMap = indexMap;
    }

    @Required
    public void setSpaceMargin(double spaceMargin) {
        this.spaceMargin = spaceMargin;
    }

    public double getSpaceMargin() {
        return this.spaceMargin;
    }
}

