/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr;

import eu.dnetlib.enabling.actions.AbstractSubscriptionAction;
import eu.dnetlib.functionality.index.solr.SolrIndexServiceImpl;
import eu.dnetlib.functionality.index.solr.utils.MDFormatReader;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.functionality.index.solr.utils.MetadataReferenceFactory;
import eu.dnetlib.functionality.index.solr.utils.Weights;
import eu.dnetlib.miscutils.dom4j.XPathHelper;
import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class MdFormatNotificationHandler
extends AbstractSubscriptionAction {
    private static final Log log = LogFactory.getLog(MdFormatNotificationHandler.class);
    private final transient ThreadLocal<SAXReader> domFactory = new ThreadLocal<SAXReader>(){

        @Override
        protected SAXReader initialValue() {
            return new SAXReader();
        }
    };
    @Resource
    private transient SolrIndexServiceImpl solrIndexService;
    @Resource
    private transient MetadataReferenceFactory mdFactory;
    @Resource
    private transient MDFormatReader mdFormatReader;
    @Resource
    private transient Weights weights;
    private boolean enabled;

    public void notified(String subscrId, String topic, String rsId, String profile) {
        if (!topic.startsWith(this.getTopicPrefix()) || !this.isEnabled()) {
            return;
        }
        try {
            Document doc = this.parse(profile);
            Node formatNode = doc.selectSingleNode("//CONFIGURATION/NAME/text()");
            if (formatNode != null && !formatNode.asXML().isEmpty()) {
                String format = formatNode.asXML();
                Iterable layouts = XPathHelper.selectElements((Node)doc, (String)"//STATUS/LAYOUTS/LAYOUT");
                log.info((Object)("found a change in mdFormat: " + format));
                for (Element element : layouts) {
                    String layout = element.attributeValue("name");
                    MetadataReference mdRef = this.mdFactory.getMetadata(format, layout);
                    if (!this.existsIndex(mdRef)) continue;
                    log.info((Object)("found fields for layout: " + layout));
                    Document fields = this.parse(element.selectSingleNode("./FIELDS").asXML());
                    this.solrIndexService.getActor(mdRef).updateSchema(fields, mdRef);
                    this.weights.put(mdRef, this.mdFormatReader.getAttributeMap(mdRef, "weight"));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean existsIndex(MetadataReference mdRef) {
        return this.solrIndexService.getSolrIndexServer().getIndexMap().isRegistered(mdRef);
    }

    private Document parse(String source) throws DocumentException {
        return this.domFactory.get().read((Reader)new StringReader(source));
    }

    @Required
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

