/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.actors;

import akka.actor.TypedActor;
import com.google.common.collect.Lists;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.functionality.index.solr.SolrIndexServer;
import eu.dnetlib.functionality.index.solr.actors.BlackboardActorCallback;
import eu.dnetlib.functionality.index.solr.actors.IndexServerActor;
import eu.dnetlib.functionality.index.solr.actors.ResultsetKeepAliveCallback;
import eu.dnetlib.functionality.index.solr.feed.FeedMode;
import eu.dnetlib.functionality.index.solr.rmi.HttpClientHelper;
import eu.dnetlib.functionality.index.solr.rmi.SolrIndexRmi;
import eu.dnetlib.functionality.index.solr.utils.MetadataReference;
import eu.dnetlib.functionality.index.solr.utils.ServiceTools;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;

public class IndexServerActorImpl
extends TypedActor
implements IndexServerActor {
    private static final Log log = LogFactory.getLog(IndexServerActorImpl.class);
    private final transient ServiceResolver serviceResolver;
    private final transient SolrIndexServer solrIndexServer;
    private final transient ServiceTools serviceTools;

    public IndexServerActorImpl(ServiceResolver serviceResolver, SolrIndexServer solrIndexServer, ServiceTools serviceTools) {
        this.serviceResolver = serviceResolver;
        this.solrIndexServer = solrIndexServer;
        this.serviceTools = serviceTools;
    }

    @Override
    public void createIndex(String dsId, MetadataReference mdRef, String fields, BlackboardActorCallback endCallback) {
        try {
            this.solrIndexServer.create(dsId, mdRef, fields);
            this.serviceTools.incrementHandledDataStructures();
            this.serviceTools.refreshServiceLastUpdate();
            endCallback.setJobDone();
        }
        catch (Throwable e) {
            endCallback.setJobFailed(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void feedIndex(String dsId, FeedMode feedMode, IterableResultSetClient docIterator, ResultsetKeepAliveCallback startCallback, BlackboardActorCallback endCallback) {
        try {
            startCallback.unschedule();
            this.solrIndexServer.feed(dsId, DateUtils.now_ISO8601(), feedMode, docIterator);
            long newIndexSize = this.solrIndexServer.getNumberOfRecords(dsId).getTotal();
            if (!feedMode.equals((Object)FeedMode.UPDATE) && !this.serviceTools.updateIndexDS(newIndexSize, dsId)) {
                log.warn((Object)("couldn't update IndexDs with Id: " + dsId));
            }
            endCallback.setJobDone();
        }
        catch (Throwable e) {
            endCallback.setJobFailed(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteByQuery(String query, String dsId, BlackboardActorCallback endCallback) {
        try {
            this.solrIndexServer.deleteByQuery(query, dsId, false);
            endCallback.setJobDone();
        }
        catch (Throwable e) {
            endCallback.setJobFailed(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void mergeIndexes(MetadataReference mdRef, List<W3CEndpointReference> epr, BlackboardActorCallback endCallback) throws IOException {
        try {
            this.doMergeIndexes(mdRef, epr);
            endCallback.setJobDone();
        }
        catch (RuntimeException e) {
            endCallback.setJobFailed(e);
            throw e;
        }
    }

    public void doMergeIndexes(MetadataReference mdRef, List<W3CEndpointReference> eprList) throws IOException {
        File tmpBaseDir = new File("/tmp/" + UUID.randomUUID());
        FileUtils.forceMkdir((File)tmpBaseDir);
        ArrayList tmpDirList = Lists.newArrayList();
        try {
            for (W3CEndpointReference epr : eprList) {
                List<URL> fileUrls = this.mapToURL(((SolrIndexRmi)this.serviceResolver.getService(SolrIndexRmi.class, epr)).getIndexFiles(mdRef.getFormat(), mdRef.getLayout(), mdRef.getInterpretation()));
                File tmpDir = new File(tmpBaseDir.getAbsolutePath() + "/" + UUID.randomUUID());
                FileUtils.forceMkdir((File)tmpDir);
                tmpDirList.add(tmpDir);
                HttpClientHelper client = new HttpClientHelper();
                for (URL url : fileUrls) {
                    client.saveTo(url, tmpDir);
                }
            }
            this.solrIndexServer.getIndexMap().mergeIndexes(mdRef, MappedCollection.listMap((Iterable)tmpDirList, (UnaryFunction)new UnaryFunction<String, File>(){

                public String evaluate(File f) {
                    return f.getAbsolutePath();
                }
            }));
            this.solrIndexServer.getIndexMap().getIndexByMetadata(mdRef).getServer().commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.forceDelete((File)tmpBaseDir);
        }
    }

    @Override
    public void updateSchema(Document fields, MetadataReference mdRef) {
        try {
            this.solrIndexServer.getIndexMap().updateIndexSchema(fields, mdRef);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getIndexFiles(MetadataReference mdRef) {
        return this.solrIndexServer.getIndexMap().listIndexFiles(mdRef);
    }

    @Override
    public int updateDocuments(String query, MetadataReference mdRef, Map<String, String> fieldXPath, String regex, String replace) {
        try {
            return this.solrIndexServer.updateDocuments(query, mdRef, fieldXPath, regex, replace);
        }
        catch (Exception e) {
            log.error((Object)("error updating documents in index: " + mdRef.toString()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sayHello() {
        System.out.println("############# Hello ###############");
    }

    private List<URL> mapToURL(List<String> list) {
        return MappedCollection.listMap(list, (UnaryFunction)new UnaryFunction<URL, String>(){

            public URL evaluate(String url) {
                try {
                    return new URL(url);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

